{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMIO11.PAS
              Uses an IO form in a window to create a
              multi-column pick-list.
}

program DEMIO11;

{$I GOLDFLAG.INC}

uses  DOS, CRT, GoldAttr, GoldMisc, GoldHard, GoldFast, GoldWin,
      GoldIO, GoldIO2, GoldLink, GoldStr, GoldKey, GoldList;

var
   SourceList: SingleLL;
   ListProperties: ListCfg;

procedure SetScreen;
{Paints the background}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,YellowOnBlue);
   ClearLine(25,LightgrayOnBlue);
   WriteCenter(25,UseTint,' Copyright (c) 1993 TechnoJock Software Inc. ');
   WriteCenter(1,UseTint,' A Multi-Column Pick List Window ');
end; {SetScreen}

procedure ShutDown;
{}
begin
   PromptOK(' ERROR! ','Not enough memory to run program!');
   halt;
end; { ShutDown }

procedure FillTheList;
{}
var I: integer;
begin
   I := 0;
   InitSLLStr(SourceList);
   SLLSetActiveList(SourceList);
   inc(I,SLLAddStr('Erica'));
   inc(I,SLLAddStr('Theresa'));
   inc(I,SLLAddStr('Shirley'));
   inc(I,SLLAddStr('Donna'));
   inc(I,SLLAddStr('Allison'));
   inc(I,SLLAddStr('Evete'));
   inc(I,SLLAddStr('Mona'));
   inc(I,SLLAddStr('Hilary'));
   inc(I,SLLAddStr('Gabby'));
   inc(I,SLLAddStr('Anne'));
   inc(I,SLLAddStr('Bonnie'));
   inc(I,SLLAddStr('Joni'));
   inc(I,SLLAddStr('Albert'));
   inc(I,SLLAddStr('Sharon 1'));
   inc(I,SLLAddStr('Sharon 2'));
   inc(I,SLLAddStr('Gillian'));
   inc(I,SLLAddStr('Helen'));
   inc(I,SLLAddStr('Sereta'));
   inc(I,SLLAddStr('Jane'));
   inc(I,SLLAddStr('Juliet'));
   inc(I,SLLAddStr('Marianne'));
   inc(I,SLLAddStr('Carla'));
   inc(I,SLLAddStr('Stella'));
   inc(I,SLLAddStr('Billi'));
   inc(I,SLLAddStr('Suzy'));
   if I <> 0 then
    ShutDown;
end; {FillTheList}

procedure SetFields;
{}
var I : Integer;
begin
   CreateForms(1);
   ActivateForm(1);
   AllowEsc(true);
   {Add all the fields}
   SetFormWindow(15,7,65,18,1);
   WinSetTitle(FormWinNum,' Tag one or more names ');
   WinSetType(FormWinNum,WMove);
   WinSetShowNum(FormWinNum,false);
   KwikAddField(1, 3,2);
   KwikAddField(2,13,9);
   KwikAddLastField(3, 30,9);
   {The List}
   FillTheList;
   InitListCfg(ListProperties);
   ListSetTagging(ListProperties,true);
   ListAssignSLL(ListProperties,SourceList);
   WrapListField(1,15,3,6,ListProperties);  {15 character columns, 3 columns wide, 4 rows deep}
   {Buttons}
   ButtonDefaultField(2,'   ~O~K   ',finished);  {OK selected if user presses Enter}
   ButtonField(3,' C~a~ncel ',escaped);
end; {SetFields}

procedure ReviewTaggedSelections;
{}
var I,ListCount: longint;
begin
   SLLSetActiveList(SourceList);
   ListCount := SourceList.TotalNodes;
   SLLDelAllStatus(TagBit,false);  {delete all items from the list that weren't tagged}
   if ListCount = SourceList.TotalNodes then
      PromptOK('','You tagged all the girls!')
   else if SourceList.TotalNodes = 0 then
      PromptOK('','You didn''t tag any girls!')
   else
   begin
      ListSetTagging(ListProperties,false);
      ListAssignSLL(ListProperties,SourceList);  {assign again cos the list size may have changed}
      RunList(ListProperties,'You tagged these girls!');
   end;
end; {ReviewTaggedSelections}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   SetFields;
   MouseShow(true);
   ProcessInput(1);
   DisposeFields;
   DisposeForms;
   ReviewTaggedSelections;
   SLLDestroy;               {dispose of the list 'cos IO won't do it!}
   GotoXY(1,21);
   MouseShow(false);
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
