{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMIO1.PAS
              Shows how to use a basic form to garner data from a user.
}

Program DemIO1;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldFast, GoldCal, GoldDate, GoldMisc, GoldKey, GoldIO,
          GoldIO2, GoldStr;

var
  Name,Tel:string;
  Age:byte;
  Sex: string[1];

procedure SetScreen;
{}
begin
   SetBlinking(false);
   Clear(LightRedOnCyan,'');
   ClearLine(1,WhiteOnBlue);
   WriteCenter(1,UseTint,'A Basic Input Form');
   WriteAt(1,2,BlueOnYellow,replicate(80,''));
   WriteAT(70,2,WhiteOnBlack,'TTT Gold!');
   Box3d(5,7,75,21,BlackOnLightGray,BlackOnLightGray,1);
   ClearLine(25,YellowOnBlue);
end; { SetScreen }

procedure SetVars;
{Sets the default values for the fields}
begin
   Name := '';
   Tel := '';
   Age  := 0;
   Sex := '';
end; { SetVars }

procedure SetFields;
{Defines the form by postioning the fields, linking the fields to
 variables, and adding labels, hotkeys and messages}
begin
   {create the 5 fields}
   KwikAddField(1, 25,9);      {Field 1, column 25, line 9}
   KwikAddField(2, 25,11);      {Field 2, column 25, line 11}
   KwikAddField(3, 25,13);      {Field 3, column 25, line 13}
   KwikAddField(4, 25,15);     {Field 4, column 25, line 15}
   KwikAddField(5, 26,18);     {Field 5, column 25, line 18}
   {Note: when using the KwikAddxxx procedures, make sure that
          the last field is always added with the procedure
          KwikAddLastField}
   KwikAddLastField(6, 43,18); {Field 6, column 43, line 18}
   {now define the individual field properties}
   {Field 1}
   StringField(1, Name, '******************************'); {Field 1, use variable Name, accept any 30 characters}
   SetLabel(1, LabelLeft,LabelLeft,'Full name:');
   {Field 2}
   StringField(2, Tel, '(###) ###-####'); {Field 2, use a format mask to define tel. field}
   SetLabel(2, LabelLeft,LabelLeft,'Tel:');
   {Field 3}
   ByteField(3, Age, '##', 13,65);  {two digit number in the range 13 to 65}
   SetLabel(3, LabelLeft,LabelLeft,'Patients age:');
   {Field 4}
   StringField(4, Sex, '!');  {single character field; force input to uppercase}
   SetLabel(4, LabelLeft,LabelLeft,'Sex:');
   {Fields 4 & 5: buttons}
   ButtonField(5,'   OK   ',finished);
   ButtonField(6,' Cancel ',escaped);
end; { SetFields }

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   SetVars;
   SetFields;
   {by default each field is checked as the user tries to move from one field
    to the next -- the following line instructs TTT to check it when OK is pressed}
   SetValidation(ValidateAtEnd);
   MouseShow(true);
   ProcessInput(1);
   GotoXY(1,25);
   DisposeFields;
   DisposeForms;
   MouseShow(false);
   Clear(LightGrayOnBlack,' ');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
