{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMINI3.PAS
              Demonstrates loading an entire section of an
              INI file into a list, using GETINISECTION.
}

program DemIni3;

{$I GOLDFLAG.INC}

uses CRT, DOS, GoldKey, GoldAttr, GoldFast, GoldIni, GoldLink, GoldList,
     GoldMisc, GoldWin;

const Msg1 = 'Load Section Demo';
      FN = 'Section.ini';
      Section = 'DOGLIST';

var SectionList: SingleLL;
    ListDetails: ListCfg;

procedure SetScreen;
{}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,WhiteOnBlue);
   WriteCenter(1,WhiteOnBlue,Msg1);
   WriteAT(68,1,YellowOnBlack,' TTT Gold! ');
   ClearLine(25,BlackOnRed);
end; { SetScreen }

begin { main }
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   MouseShow(true);
   InitListCfg(ListDetails);
   with ListDetails do
   begin
      WX1 := 25;
      WY1 := 5;
      WX2 := 55;
      WY2 := 20;
   end;
   InitSLLStr(SectionList);
   if GetIniSection(SectionList,Section,FN) = 0 then
   begin
      PromptOK(' NOTE ','This example uses GETINISECTION');
      ListAssignSLL(ListDetails,SectionList);
      RunList(ListDetails,' Dog List ');
      SLLDestroy;
      PromptOK(' TTTGOLD ','Dogs are a man''s best friend...');
   end else
      PromptOK(' Load Failure ','Unable to locate '+FN+' or '+Section+'.');
   MouseShow(false);
   Clear(LightGrayOnBlack,' ');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
