{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMINI2.PAS
              Edits a text file with word wrapping turned off.
              Also modifies date and time each time it is executed.
}

program DemIni2;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldFast, GoldMisc, GoldLink, GoldKey, GoldWin,
          GoldMemo, GoldINI, GoldDate;

const
     TextFileName = 'DEMINI.INI';

var
  TextData: SingleLL;
  MemoSettings: MemoCfg;

procedure SetScreen;
{}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,RedOnLightGray);
   WriteCenter(1,UseTint,'TTT Gold');
   ClearLine(25,BlackOnLightGray);
   WritePlain(8,25,'');
end; { SetScreen }

procedure SetVars;
{}
var ECode: integer;
begin
   InitSLLStr(TextData);
   SLLSetActiveList(TextData);
   if SLLLoadFromFile(TextFileName) <> 0 then {file not found}
   begin
      PromptOK(' Internal error ','Unable to load '+TextFileName);
      halt;
   end;
   MemoVars.WY2 := 17;
end; {SetVars}

procedure SetCfg;
{}
begin
   with MemoSettings do
   begin
      InitMemoCfg(MemoSettings);
      MemoAssignSLL(MemoSettings,TextData);
   end;
end; { SetCfg }

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   SetVars;
   SetCfg;
   MouseShow(true);
   PromptOK(' INI File Support ','Gold provides routines for reading & writing'+
            '|Windows-style INI files. In this example, the|~[LAST ACCESS]~ section '+
            'is automatically updated|using the ~WriteIniString~ function '+
            'every time|this program is run.');
   RunMemo(MemoSettings,' A Typical INI file ');  {no word wrap}
   MouseShow(false);
   SLLSetActiveList(TextData);
   SLLDestroy;
   if WriteIniString('Last Access','Date',FancyDateStr(TodayInJul,false,false),'DEMINI.INI') = 0 then ;
   if WriteIniString('Last Access','Time',LongToTimeStr(NowInLong,HHMMSS,true,false),'DEMINI.INI') = 0 then ;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
