{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DemDir7.pas
              Illustrates how to customize the PromptDir display colors.
}

program DemDir7;

{$I GOLDFLAG.INC}

uses CRT, DOS, GoldAttr, GoldFast, GoldLink, GoldDir, GoldHard,
               GoldMisc, GoldIO, GoldKey, GoldWin, GoldTint;

var DirName: string;

procedure SetScreen;
{Paints the background}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,YellowOnBlue);
   ClearLine(25,LightCyanOnBlue);
   WritePlain(8,25,'');
   WriteCenter(1,UseTint,' File List ');
   GotoXY(1,1);
end; {SetScreen}

procedure CustomizeColors;
{}
begin
   {first the window border}
   GoldSetColor(IOWinTitle,WhiteonMagenta);
   GoldSetColor(IOWinIcons,GreenonMagenta);
   GoldSetColor(IOWinBorder1,YellowonMagenta);
   GoldSetColor(IOWinBody,YellowonMagenta);
   {now the buttons}
   GoldSetColor(IOButtonNormHot,WhiteOnBlue);
   GoldSetColor(IOButtonNorm,YellowOnBlue);
   GoldSetColor(IOButtonHiHot,WhiteonRed);
   GoldSetColor(IOButtonHi,YellowOnRed);
   {now the list fields}
   GoldSetColor(ListHi1,WhiteOnRed);
   GoldSetColor(ListNorm1,LightcyanOnBlue);
   GoldSetColor(ListScrollBarHi,LightcyanOnBlue);
   {and finally the messages}
   GoldSetColor(IOLabelNorm,CyanOnMagenta);
   GoldSetColor(IOLabelHi,LightcyanOnMagenta);
end; { CustomizeColors }

begin { main }
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   CustomizeColors;
   MouseShow(true);
   DirName := PromptDir('','');
   if DirName = '' then
      PromptOK('','You Cancelled!')
   else
      PromptOK('','You chose '+DirName);
   writeln('Press Enter to continue');
   MouseShow(false);
   Clear(LightGrayOnBlack,' ');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
