{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMDIR12.PAS
              Shows how to customize the display colors used by FileList.
}

program DemDir12;

{$I GOLDFLAG.INC}

uses CRT, DOS, GoldAttr, GoldFast, GoldLink, GoldDir, GoldHard,
               GoldMisc, GoldIO, GoldKey, GoldWin, GoldTint;

var FileName: string;

procedure SetScreen;
{Paints the background}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,YellowOnBlue);
   ClearLine(25,LightCyanOnBlue);
   WritePlain(8,25,'');
   WriteCenter(1,UseTint,' File List ');
   GotoXY(1,1);
end; {SetScreen}

procedure CustomizeColors;
{}
begin
   {first the window border}
   GoldSetColor(ListTitle,WhiteonMagenta);
   GoldSetColor(ListIcons,LightgrayOnMagenta);
   GoldSetColor(ListBorder1,YellowonMagenta);
   GoldSetColor(ListBorder2,BlackonMagenta);
   GoldSetColor(ListNorm1,BlackonMagenta);
   {now the list fields}
   GoldSetColor(ListNorm1,YellowOnMagenta);  {files}
   GoldSetColor(ListHi1,WhiteOnCyan);
   GoldSetColor(ListNorm2,WhiteOnMagenta);   {directories and drives}
   GoldSetColor(ListHi2,BlackOnCyan);
   GoldSetColor(ListScrollBarHi,LightgrayOnMagenta);
   {now the file info}
   GoldSetColor(DirListInfo,LightgrayonMagenta);
end; { CustomizeColors }

begin { main }
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   DirVars.LWinStyle := 7;
   SetScreen;
   CustomizeColors;
   MouseShow(true);
   FileName := FileList('*.*',' Pick a file -- any file! ');
   if Filename = '' then
      PromptOK('','You Cancelled!')
   else
      PromptOK('','You chose '+FileName);
   MouseShow(false);
   Clear(LightGrayOnBlack,' ');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
