{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMDESK6.PAS
              A desktop for browsing text files. Also shows
              how to add a standard "Window" menu.
}

program DEMDESK6;

uses DOS, CRT, GoldFast, GoldWin, GoldMenu, GoldMisc, GoldDesk, GoldKey,
               GoldCalc, GoldCal, GoldDate, GoldStr, GoldList, GoldLink,
               GoldDir, GoldHard;

const
   LoadMask = '*.pas';

var
   MainMenu,
   StatusBar: Bar;
   SubMenu,
   WinMenu: PopUp;
   Action : dAction;

                         {***********************}
                         {**  Menu Management  **}
                         {***********************}

{$F+}
procedure MenuHelp(ID:integer);
{}
begin
   PromptOK(' Help! ','You asked for help on menu item ID: '+IntToStr(ID));
end; { MenuHelp }
{$F-}

procedure DefineSubMenus;
{}
begin
   InitPopUp(SubMenu);
   PopUpAddItem(SubMenu,'~B~rowse a file',101,67,'Display a text file in a window',nil);
   PopUpAddItem(SubMenu,'~A~bout',102,65,'Show version and copyright information',nil);
   PopUpAddItem(SubMenu,'E~x~it',999,88,'~Exit~ this little demo',nil);
   InitPopUp(WinMenu);
   PopUpAddItem(WinMenu,'~T~ile',901,84,'Arrange windows on desktop by tiling',nil);
   PopUpAddItem(WinMenu,'C~a~scade',902,65,'Arrange windows on desktop by cascading',nil);
   PopUpAddItem(WinMenu,'Cl~o~se all',903,79,'Close all windows on the desktop',nil);
   PopUpAddItem(WinMenu,'~R~efresh display',904,82,'Redraw the screen',nil);
   PopUpAddItem(WinMenu,'-',0,0,'',nil);
   PopUpAddItem(WinMenu,'~M~ove:Ctrl+F5',905,83,'Change the size or position of the active window',nil);
   PopUpAddItem(WinMenu,'~S~tretch:',906,83,'Change the size or position of the active window',nil);
   PopUpAddItem(WinMenu,'~Z~oom:F5',907,90,'Enlarge or restore the size of the active window',nil);
   PopUpAddItem(WinMenu,'~N~ext:F6',908,78,'Make the next window active',nil);
   PopUpAddItem(WinMenu,'~P~revious:Shift+F6',909,80,'Make the previous window active',nil);
   PopUpAddItem(WinMenu,'~C~lose:Alt+F3',910,67,'Close the active window',nil);
   PopUpAddItem(WinMenu,'-',0,0,'',nil);
   PopUpAddItem(WinMenu,'~L~ist...:Alt+0',911,76,' Show a list of all open windows',nil);
end; { DefineSubMenus }

procedure DefineMainMenu;
{}
begin
   InitBar(MainMenu);
   BarAddItem(MainMenu,'~T~ools',100,84,276,'Select one of Desktop tools',@SubMenu);
   BarAddItem(MainMenu,'~W~indow',200,87,273,'Open, arrange and list windows',@WinMenu);
   BarAddHK(MainMenu,354,905); {Ctrl+F5 - Move}
   BarAddHK(MainMenu,364,906); {Alt+F5 - Stretch}
   BarAddHK(MainMenu,319,907); {F5 - Zoom}
   BarAddHK(MainMenu,320,908); {F6 - Next}
   BarAddHK(MainMenu,345,909); {Shift+F6 - Previous}
   BarAddHK(MainMenu,342,910); {Alt+F3 - Close}
   BarAddHK(MainMenu,385,911); {Alt+0 - List}
   MainMenu.Style := 2;
   AssignMenuHelpHook(MainMenu,MenuHelp);
end; { DefineMainMenu }

procedure DefineStatusBar;
{}
begin
   InitBar(StatusBar);
   BarAddItem(StatusBar,'~F1~ Help',1001,315,315,'',nil);
   BarAddItem(StatusBar,'~Alt+X~ Exit the demo',999,301,301,'',nil);
end; { DefineStatusBar }

procedure DisposeMenus;
{}
begin
   DestroyBar(MainMenu);
   DestroyPopUp(SubMenu);
   DestroyPopUp(WinMenu);
   DestroyBar(StatusBar);
end; { DisposeMenus }

                           {*******************}
                           {**  File Loader  **}
                           {*******************}

procedure LoadFile;
{}
var
  Fname: string;
  RetCode: integer;
begin
   FName := PromptFile(Loadmask);
   if Fname <> '' then
   begin
      with ListVars do  {set the position and dimensions of the new window}
      begin
         DeskNextWinCoords(WX1,WY1);
         WX2 := HardVars.Width;
         WY2 := HardVars.Depth - BBBot;
      end;
      RetCode := LaunchBrowseFile(Fname,' '+Fname+' ');
   end;
end; { LoadFile }

                            {*****************}
                            {**  Scheduler  **}
                            {*****************}
{$F+}
procedure MyActionProc(Choice:integer;var Action:DAction);
{}
begin
   case Choice of
     101: LoadFile;
     102: PromptOK(' Tools Demo ','^Copyright 1995 TechnoJock Software, Inc.|'+
                     '^All Rights Reserved');
     {Window options}
     901: if not DeskTile then
        PromptOK(' Message ','Unable to tile the windows');
     902: DeskCascade;
     903: if not DeskCloseAllWindows then
        PromptOK(' Message ','Unable to close all windows');
     904: DeskRefresh;
     905:  if not DeskMoveTopWin then
        PromptOK(' Message ','The top window cannot be moved');
     906:  if not DeskStretchTopWin then
        PromptOK(' Message ','The top window cannot be stretched');
     907:  if not DeskZoomTopWin then
        PromptOK(' Message ','The top window cannot be zoomed');
     908: DeskNextWin;
     909: DeskPrevWin;
     910: Action := DCloseTop;
     911: DeskWinList;
     {help and quit}
     1001: PromptOK(' Tools Help ','^Honey if you need help, we got problems!');
     999: Action := DFinished;
   end;
end; { MyActionProc }
{$F-}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   DefineSubMenus;
   DefineMainMenu;
   DefineStatusBar;
   DeskAssignMainMenu(MainMenu);
   DeskAssignActionProc(MyActionProc);
   DeskAssignStatusBar(Statusbar);
   SetBlinking(false);
   MouseShow(true);
   CursorOff;
   Action := DeskProcessInput;
   CursorOn;
   MouseShow(false);
   DisposeMenus;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
