{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMCAL6.PAS
              Shows how to use a change hook combined with a character
              hook to add date-smart hotkeys.
}

Program DemCal6;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldWin,
     GoldStr, GoldFast, GoldCal, GoldDate, GoldMisc, GoldKey;

var
   SelectedDay,
   Answer : Dates;

procedure SetScreen;
{Paints the background}
begin
   SetBlinking(false);
   Clear(WhiteOnLightGray,' ');
   ClearLine(1,BlackOnYellow);
   ClearLine(2,BlackOnYellow);
   WriteAT(1,3,LightgrayOnYellow,replicate(80,''));
   WriteAT(68,3,WhiteOnBlack,' TTT Gold! ');
   ClearLine(25,BlackOnYellow);
   WriteHiCenter(25,LightredOnYellow,0,'~F1~ NoHelp   ~Alt-A~ Appointments   ~ESC~ to finish');
   Box(15,20,65,22,BlackOnLightgray,1);
end; {SetScreen}

{$F+}
procedure CharacterHook(var Key:word; var X,Y: byte);
{}
begin
   case Key of
      315: PromptOK(' No Help ','You just can''t get good|help these days.');
      286: PromptOK(' Getta Life ','Pretend this was your appointment list|for '+
                    JultoStr(SelectedDay,MMDDYY));
   end; {case}
end; { CharacterHook }

procedure ChangeHook(CType:gCalChange;Val1,Val2:dates);
{}
begin
   if CType = ChangeDay then
   begin
      SelectedDay := Val2;
      ActivateBackground;
      WriteCenter(21,0,PadCenter(FancyDateStr(val2,true,true),40,' '));
      ActivateTopWindow;
      WinDrawAll;
   end;
end; { ChangeHook }
{$F-}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   MouseShow(true);
   with CALVars do
   begin
     dec(WY1,4);
     dec(WY2,4);
   end;
   AssignCalCharHook(CharacterHook);
   AssignCalChangeHook(ChangeHook);
   Answer := RunCalendar(TodayInJul,' A Calendar! ');
   if CalVars.ChooseDay then
   begin
      if Answer = 0 then
         PromptOK('','You escaped!')
      else
         PromptOK('',' You selected '+FancyDateStr(Answer,false,false));
   end;
   ResetStartupMode;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
