{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMCAL5.PAS
              Shows how to customize the display colors for individual
              days in a pop-up calendar.
}

Program DemCal5;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldWin, GoldTint, GoldStr, GoldFast,
          GoldCal, GoldDate, GoldMisc, GoldKey;

var
   Answer : Dates;

procedure SetScreen;
{Paints the background}
begin
   SetBlinking(false);
   Clear(BlueOnLightred,' ');
   ClearLine(1,BlackOnYellow);
   ClearLine(2,BlackOnYellow);
   WriteAT(1,3,LightredOnYellow,replicate(80,''));
   WriteAT(68,3,WhiteOnBlack,' TTT Gold! ');
   ClearLine(25,BlackOnYellow);
   WriteCenter(25,0,'Press ESC to finish...');
end; {SetScreen}


{$F+}
procedure ChangeFriSatSun(TheDay:Dates; var TheCol:byte);
{}
var DOW: byte;
begin
   if TheCol = GoldGetColor(CalActiveMonth) then
   begin
      DOW := DOWJul(TheDay);
      case DOW of
         5: TheCol := LightGreenOnBlue;
         0,6: TheCol := GreenOnBlue;
      end;
   end;
end; { ChangeFriSatSun }
{$F-}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   MouseShow(true);
   AssignCalColorHook(ChangeFriSatSun);
   Answer := RunCalendar(TodayInJul,' A Calendar! ');
   if CalVars.ChooseDay then
   begin
      if Answer = 0 then
         PromptOK('','You escaped!')
      else
         PromptOK('',' You selected '+FancyDateStr(Answer,false,false));
   end;
   ResetStartupMode;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
