{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMCAL1.PAS
              Shows how to display a pop-up calendar using Toolkit defaults.
}

Program DemCal1;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldWin, GoldStr, GoldFast, GoldCal, GoldDate,
          GoldMisc, GoldKey;

var
   Answer : Dates;

procedure SetScreen;
{Paints the background}
begin
   SetBlinking(false);
   Clear(BlueOnLightred,' ');
   ClearLine(1,BlackOnYellow);
   ClearLine(2,BlackOnYellow);
   WriteAT(1,3,LightredOnYellow,replicate(80,''));
   WriteAT(68,3,WhiteOnBlack,' TTT Gold! ');
   ClearLine(25,BlackOnYellow);
   WriteCenter(25,0,'Press ESC to finish...');
end; {SetScreen}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   MouseShow(true);
   (* enable the following line if you don't want the
      user to select a specific day
   CalVars.ChooseDay := false;
   *)
   Answer := RunCalendar(TodayInJul,' A Calendar! ');
   if LastCalError <> 0 then
      promptOK(' Error ','Insufficient memory to display the calendar')
   else
   begin
      if CalVars.ChooseDay then
      begin
         if Answer = 0 then
            PromptOK('','You escaped!')
         else
            PromptOK('',' You selected '+FancyDateStr(Answer,false,false));
      end;
   end;
   ResetStartupMode;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
