{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMBRS3.PAS
              Shows how to display  the contents of an SLL in a browse
              window.
}

Program DEMBRS3;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldMisc, GoldFast, GoldLink, GoldList, Goldkey,
          GoldDir, GoldWin, GoldStr;

var
  SLL: SingleLL;
  Settings: ListCfg;

procedure SetScreen;
{}
begin
   Clear(BlueOnLightRed,' ');
   ClearLine(1,YellowOnLightBlue);
   WriteCenter(1,0,' Browsing Gold-Style ');
   ClearLine(25,BlackOnYellow);
   WriteCenter(25,0,'Press ESC to finish...');
end; { SetScreen }

procedure PopulateTheList;
{Loads some data into SLL}
var X, I:integer;
begin
   for I := 1 to 150  do
   begin
      X := SLLAddStr('Line number '+IntToStr(I));
      if X <> 0 then
      begin
         PromptOK(' FATAL ERROR ','Insufficient memory to run program');
         Clear(LightGrayOnBlack,' ');
         Halt;
      end;
   end;
end; { PopulateTheList }

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetBlinking(false);
   SetScreen;
   MouseShow(true);
   KeySetFast;
   {now set the browse details}
   InitSLLStr(SLL);
   SLLSetActiveList(SLL);
   PopulateTheList;
   InitListCfg(Settings);
   ListAssignSLL(Settings,SLL);
   ListSetWin(Settings,28,3,52,22,1);
   CursorOff;
   RunBrowse(Settings,' Browsing ');
   SLLDestroy;
   ResetStartUpMode;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end. {DEMBRS3}
