{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMBRS1.PAS
              Shows how to display a text file in a browse window.
}

Program DEMBRS1;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldMisc, GoldFast, GoldList, Goldkey, GoldDir,
          GoldStr, GoldWin;

var
  Filename:string;

procedure SetScreen;
{}
begin
   Clear(BlueOnLightRed,' ');
   ClearLine(1,YellowOnLightBlue);
   WriteAT(1,2,LightBlueOnYellow,replicate(80,''));
   WriteAT(1,3,LightRedOnYellow,replicate(80,''));
   WriteAT(68,3,WhiteOnBlack,' TTT Gold! ');
   ClearLine(25,BlackOnYellow);
   WriteCenter(25,0,'Press ESC to finish...');
end; { SetScreen }

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetBlinking(false);
   SetScreen;
   MouseShow(true);
   KeySetFast;
   FileName := FileList('*.pas *.doc *.txt',' Pick a file -- any file! ');
   if Filename = '' then
      PromptOK('','You Cancelled!')
   else
   begin
      CursorOff;
      RunBrowseFile(Filename,' Browsing '+FileName);
   end;
   MouseShow(false);
   ResetStartupMode;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end. {DEMBRS1}
