DEFINT A-Z

'==========================================================================
'
'    Name:       Demo_Prn.Bas   Copyright 1992-1994, Rob W. Smetana
'             
'                The Printer (tm) support file.
'
'                NOTE:  PowerBASIC users must UN-REM one line below.
'
'
' Purpose:       * Demonstrate reading printer records.
'
'                * Demonstrate using TYPE.INC (and when not to).
'
'                * Show how one might display printer codes.
'
'                  Something like this might be used inside a
'                  program to show users which codes are
'                  available (ie., not blank) and perhaps what
'                  they should do to invoke each option.
'
'    NOTE:       Some printer codes may contain control codes which screw
'                up the display when printed.  Try a different printer.
'                And in your own programs you might want to use an ASM
'                "quickprint" routine to overcome this problem.
'
'Requires:       Printer.Cfg.  BEFORE running this, you MUST run Printer.Exe,
'                select a printer, and press F2 to SAVE Printer.Cfg.
'                THIS program will display the contents of Printer.Cfg.
'
'                The_Prn.Bas, an "include file" containing 2 TYPES you
'                may use to read printer control codes.
'
'==========================================================================

'...include two TYPES useful for reading printer codes.

'$INCLUDE: 'The_Prn.Bas'       '<<--- Microsoft BASICS (QB, PDS, VBDOS)

''$INCLUDE "The_Prn.Bas"       '<<--- PowerBASIC users, UN-REM this line

'...NOTE:  Although we loaded a TYPE to read printer codes, we won't use it!
'   For what we're about to do, it's more code efficient to read stuff
'   using some simple 980-byte strings.

Labels$ = SPACE$(980)
Codes$ = Labels$

COLOR , 1: CLS

OPEN "Printer.Cfg" FOR BINARY AS #1         '...this MUST already exist!!!
IF LOF(1) < 2000 THEN
   CLOSE
   PRINT "Error:  Printer.Cfg may not exist or it's too small.  Run Printer.Exe,"
   PRINT "select a printer, then press F2 to save codes to Printer.Cfg."
   END
END IF

    GET #1, , Header                        '...we WILL use the header
    GET #1, , Labels$                       '...so we can print descriptions

    GET #1, , Header                        '...Get again so we're in position
                                            '   to read codes.
    GET #1, , Codes$                        '...so we can print printer codes

CLOSE

'...Now display them


PRINT "   You chose a printer made by :  "; Header.Manufacturer;
PRINT "                  The Model is :  "; Header.Model

IF LEN(RTRIM$(Header.EmMode)) THEN       '...if it's emulating another ...

    PRINT "     This printer is emulating :  "; RTRIM$(Header.EmMode)
    It.Is.Emulating = -1

END IF

PRINT : PRINT

'...Now for the codes

FOR x = 1 TO 70

    '...Starting at column 1, print 70, 14-byte fields.

    Where = 1 + ((x - 1) * 14)


    '...Printing this way is simpler than printing separate TYPE members.

    PRINT "     "; MID$(Labels$, Where, 14); "   "; MID$(Codes$, Where, 14),


    '...They won't all fit on 1 screen, so pause, then display the rest.

    IF CSRLIN > 22 AND x < 70 THEN

       LOCATE 25, 20: PRINT "Press any key to see the rest . . .";
       d$ = INPUT$(1)

       LOCATE 5, 1
       IF It.Is.Emulating = False THEN PRINT

    END IF

NEXT

