'***************************************************************************
'Copyright 1995, P. Scott Antony
'P.O. Box 11047
'Milwaukee, WI  53211
'74002,2373@compuserve.com
'PSAntony@aol.com
'***************************************************************************

'SAME AS ROTARY.BAS BUT PRINTS TO A FORM ISTEAD OF THE PRINTER OBJECT.
'SEE ROTARY.BAS FOR INFO.

'***************************************************************************
'These variables are only DIMensioned for THIS module.

'ROTARY CARD VARIABLES
Dim RAD_CONV As Double
Dim rotTabX As Double
Dim rotTabY As Double
Dim rotNameX As Double
Dim rotNameY As Double
Dim rotWidth As Double
Dim rotHeight As Double
Dim rotMid As Double
Dim rotBar As Double
Dim rotMsg As String
Dim rotCurStyle As Integer
Dim rotArcColor As Integer

'These variables are GLOBAL.
Global CurCard As Integer
Global CurLine As Integer
Global CurTab As Integer
Global CurCorner As Integer

'These are Global Constants so you can call frmPrint_Rotary() from any module.

'BELOW ARE REMMED OUT BECAUSE BOTH MODULES ARE BEING USED TOGETHER.
'RE-ENABLE THE CONSTANTS BELOW IF YOU SPLIT UP THE MODULES!

'ROTARY CARD SIZE CONSTANTS
'Global Const CARD_2x4 = 0
'Global Const CARD_3x5 = 1

'ROTARY CARD TAB STYLES
'Global Const NO_TAB = 0
'Global Const LEFT_TAB = 1
'Global Const RIGHT_TAB = 2
'
'ROTARY CARD LINE STYLES
'Global Const SOLID_LINE = 0
'Global Const DASHED_LINE = 1
'Global Const DOTTED_LINE = 2
'Global Const DASHDOT_LINE = 3
'Global Const DASHDOTDOT_LINE = 4

'ROTARY CARD CORNER STYLES
'Global Const SQ_CORNER = 0
'Global Const RND_CORNER = 1

'PI
'Global Const PI = 3.14159265358979     'used for RAD_CONV

Sub DrawRotaryForm ()
Dim cntr As Integer
Dim msg As String

'Determine which menu items are selected (they're syncronized
'with the constants)...
'*********************************
CurCard = 0
For cntr = 0 To 1
    If Form1.mnuCardType(cntr).Checked Then CurCard = cntr
Next
'*********************************
CurTab = 1
For cntr = 0 To 2
    If Form1.mnuTab(cntr).Checked Then CurTab = cntr
Next
'*********************************
CurLine = 0
For cntr = 0 To 4
    If Form1.mnuLineSty(cntr).Checked Then CurLine = cntr
Next
'*********************************
CurCorner = 0
For cntr = 0 To 1
    If Form1.mnuCrnr(cntr).Checked Then CurCorner = cntr
Next
'*********************************
'clear the form
Form1.Refresh

'* call the routine to draw the card on the form.
Call frmPrint_Rotary(.25, 1, CurCard, CurTab, CurLine, CurCorner)
'*********************************

'create the text describing the current forumla being used, and place
'in the Text box (the remaining is ONLY for the purposes of this DEMO).
msg = "Print_Rotary X, Y, "
If CurCard = 0 Then
    msg = msg & "CARD_2x4"
Else
    msg = msg & "CARD_3x5"
End If
msg = msg & ", "
If CurTab = 0 Then
    msg = msg & "NO_TAB"
End If
If CurTab = 1 Then
    msg = msg & "LEFT_TAB"
End If
If CurTab = 2 Then
    msg = msg & "RIGHT_TAB"
End If
msg = msg & ", "
Select Case CurLine
    Case 0
        msg = msg & "SOLID_LINE"
    Case 1
        msg = msg & "DASHED_LINE"
    Case 2
        msg = msg & "DOTTED_LINE"
    Case 3
        msg = msg & "DASHDOT_LINE"
    Case 4
        msg = msg & "DASHDOTDOT_LINE"
End Select
msg = msg & ", "
If CurCorner = 0 Then
    msg = msg & "SQ_CORNER"
Else
    msg = msg & "RND_CORNER"
End If
msg = msg & ", True"
Form1.Text1 = msg
'*********************************

End Sub

'
'This is the Main Subroutine (it calls ALL other Subroutines in this module)
'
'Pass rBeginX and rBeginY as the "Upper Left Corner of Rectangle" (in inches)
'* If you pass a Variable for rBeginX or rBeginY, instead of numbers,
'  it MUST be of 'Double' Type!
'
'Pass rSize from the CONSTANTS - CARD_2x4 (0) or CARD_3x5 (1)
'Pass rTab from the CONSTANTS - NO_TAB (0), or LEFT_TAB (1), or RIGHT_TAB (2)
'Pass rLineType from the CONSTANTS - SOLID_LINE (0), etc.
'Pass rCorner from the CONSTANTS - SQ_CORNER (0), RND_CORNER (1)
'
'EXAMPLE:
'Call frmPrint_Rotary(1, 1, CARD_2x4, LEFT_TAB, DOTTED_LINE, RND_CORNER)
'
Sub frmPrint_Rotary (rBeginX As Double, rBeginY As Double, rSize As Integer, rTab As Integer, rLineType As Integer, rCorner As Integer)

Select Case rSize
    
    '2" x 4" card
    Case 0  'I don't use the constants here, in case you delete them.
        rotWidth = 4
        rotHeight = 2.2
        rotMid = 7
        rBarX = 2.15
        rBarY = 1.5
        rotMsg = "For Your 2"" x 4"" Rotary File"
    
    '3" x 5" card
    Case 1  'I don't use the constants here, in case you delete them.
        rotWidth = 5
        rotHeight = 2.95
        rotMid = 15
        rBarX = 2.5
        rBarY = 2.25
        rotMsg = "For Your 3"" x 5"" Rotary File"
End Select
'Set the scale to inches
Form1.ScaleMode = 5
'DrawWidth must be 1 for dotted/dashed lines
Form1.DrawWidth = 1
Form1.DrawStyle = rLineType
'*************************************************************************
'compensate for rounded corners
If rCorner = 1 Then
    rotWidth = rotWidth - .1
    rotHeight = rotHeight - .1
End If
'top of card
Select Case rTab
    Case 0  'no Tab
        If rCorner = 1 Then
            'offset X and make room for next arc
            Form1.Line (rBeginX + .1, rBeginY)-Step(rotWidth - .1, 0)
        Else
            'start at the corner
            Form1.Line (rBeginX, rBeginY)-Step(rotWidth, 0)
        End If
    
    Case 1  'left Tab
        'begin the tab (angle up)
        Form1.Line (rBeginX, rBeginY)-Step(.2, -.3)
        '*************************************************************************
            'grab the CurrentX and CurrentY to put text here later
            rotTabX = Form1.CurrentX + .05
            rotTabY = Form1.CurrentY + .06
        '*************************************************************************
        'top of the tab
        Form1.Line Step(0, 0)-Step(1.95, 0)
        'finish the tab (angle down)
        Form1.Line Step(0, 0)-Step(.2, .3)
        'draw up to the right of the tab
        Form1.Line Step(0, 0)-Step(((rotWidth - 3) + .625), 0)
    
    Case 2  'Right Tab
        'draw up to the left of the tab
        If rCorner = 1 Then
            'don't offset Y and make room for next arc
            Form1.Line (rBeginX + .1, rBeginY)-Step(((rotWidth - 3) + .625), 0)
        Else
            'move back to the corner
            Form1.Line (rBeginX, rBeginY)-Step(((rotWidth - 3) + .625), 0)
        End If
        'begin the tab (angle up)
        Form1.Line Step(0, 0)-Step(.2, -.3)
        '*************************************************************************
            'grab the CurrentX and CurrentY to put tab text here later
            rotTabX = Form1.CurrentX + .05
            rotTabY = Form1.CurrentY + .06
        '*************************************************************************
        'top of the tab
        Form1.Line Step(0, 0)-Step(1.95, 0)
        'finish the tab (angle down)
        Form1.Line Step(0, 0)-Step(.2, .3)
End Select

If rTab <> 2 Then  'if not a right tab
    Call frmPrintArc(1, .1, rCorner)
End If

'down the right side
If rTab <> 2 Then 'I drew the arc
    If rCorner = 1 Then
        'don't offset Y and make room for next arc
        Form1.Line Step(.1, 0)-Step(0, rotHeight - .1)
    Else
        'move back to the corner
        Form1.Line Step(.1, -.1)-Step(0, rotHeight)
    End If
Else
    Form1.Line Step(0, 0)-Step(0, rotHeight)
End If

'add the lower right ARC
Call frmPrintArc(4, .1, rCorner)

'bottom right corner
If rCorner = 1 Then
    'don't offset X and compensate
    Form1.Line Step(0, .1)-Step(-((1 + rotMid / 16) - .1), 0)
Else
    'move back to the corner
    Form1.Line Step(.1, .1)-Step(-(1 + rotMid / 16), 0)
End If

'Print the T Hole
Call frmPrintTHole

'bottom middle
Form1.Line Step(0, 0)-Step(-.875, 0)

'Print the T Hole
Call frmPrintTHole

'bottom left corner
If rCorner = 1 Then
    'stop short
    Form1.Line Step(0, 0)-(rBeginX + .1, rBeginY + rotHeight + .1)
Else
    'move back to the corner
    Form1.Line Step(0, 0)-(rBeginX, rBeginY + rotHeight)
End If

'add the lower left ARC
Call frmPrintArc(3, .1, rCorner)

'left side
If rCorner = 1 Then
    If rTab <> 1 Then
        'don't offset Y and compensate
        Form1.Line Step(-.1, 0)-Step(0, -rotHeight + .1)
    Else
        'don't offset Y and compensate
        Form1.Line Step(-.1, 0)-Step(0, -rotHeight)
    End If
Else
    'move back to the corner
    Form1.Line Step(-.1, .1)-Step(0, -rotHeight)
End If

'add the upper left ARC
If rTab <> 1 Then
    Call frmPrintArc(2, .1, rCorner)
End If
'************************************************************
'Print the Scissors Wingding
Select Case rTab
    Case 1  'if a left tab, place on the right
        Call frmPrintScissors(rBeginX + rotWidth - .25, rBeginY)
    
    Case Else   'otherwise place on the left.
        Call frmPrintScissors(rBeginX, rBeginY)
End Select
'************************************************************
'middle vertical line (NOT the Exact middle, adjusted for MY text)
Form1.DrawWidth = 3   'big line
Form1.Line (rBeginX + rBarX, rBeginY + .125)-Step(0, rBarY)
Form1.DrawWidth = 1   'regular line
'************************************************************
'Description text under card
'Enable the following GoTo, to bypass this text.
'GoTo NoCardDesc
    Form1.FontName = "Arial"
    Form1.FontBold = False
    Form1.FontSize = 9.75
    Form1.CurrentX = rBeginX + ((rotWidth - Form1.TextWidth(rotMsg)) / 2)
    If rCorner = 1 Then
        Form1.CurrentY = rBeginY + rotHeight + .2
    Else
        Form1.CurrentY = rBeginY + rotHeight + .1
    End If
    Form1.Print rotMsg

NoCardDesc:
'************************************************************
'Enter Text on the Tab
Select Case rTab
    Case 0  'if no tab
        'do nothing
    Case Else   'otherwise print the tab
        Call frmPrintTabText
End Select
'************************************************************
'Enter Name/Address on the Card
Call frmPrintCardText(rBeginX, rBeginY)
'************************************************************
End Sub

Sub frmPrintArc (Qdrnt As Integer, rRad As Double, rCorner As Integer)
'Qdrnt = The quadrant to draw (see below)
'rRad  = The radius of the Arc.

rotCurStyle = Form1.DrawStyle    'grab the current DrawStyle

'enable the following line for ALWAYS DOTTED_LINE, or other.
'With this you can place a dotted arc on a solid frame, or any other
'combination. You could pass this parameter as well if you wish.

'Form1.DrawStyle = DOTTED_LINE

rRadX = rRad
rRadY = rRad
'radian conversion (sorry, I like degrees)
RAD_CONV = PI / 180
rotArcColor = 0    'black

'Print 1 of the 4 Arcs.
'(rotArcColor is set to 0 (black) in the declarations as a Constant)
Select Case Qdrnt
    Case 1  'upper right
        If rCorner = 1 Then rRadX = 0   'assumes coming in from the left
        Form1.Circle Step(-rRadX, rRadY), rRad, QBColor(rotArcColor), (0 * RAD_CONV), (90 * RAD_CONV)
    
    Case 2  'upper left
        If rCorner = 1 Then rRadY = 0   'assumes coming in from the bottom
        Form1.Circle Step(rRadX, rRadY), rRad, QBColor(rotArcColor), (90 * RAD_CONV), (180 * RAD_CONV)
    
    Case 3  'lower left
        If rCorner = 1 Then rRadX = 0   'assumes coming in from the right
        Form1.Circle Step(rRadX, -rRadY), rRad, QBColor(rotArcColor), (180 * RAD_CONV), (270 * RAD_CONV)
    
    Case 4  'lower right
        If rCorner = 1 Then rRadY = 0   'assumes coming in from the top
        Form1.Circle Step(-rRadX, -rRadY), rRad, QBColor(rotArcColor), (270 * RAD_CONV), (0 * RAD_CONV)
End Select

Form1.DrawStyle = rotCurStyle   'reset to incoming DrawStyle

End Sub

Sub frmPrintCardText (rBeginX As Double, rBeginY As Double)
    
    'rBeginX and Y are passed UNALTERED from the calling routine,
    'so add an offset. DON't alter rBeginX and Y, so use your own
    'variable name (rotNameX and rotNameY).

    rotNameX = rBeginX + .15
    rotNameY = rBeginY + .15
    
    'set up the size, bold, etc.
    Form1.FontItalic = False
    Form1.FontBold = True
    Form1.FontSize = 12
    Form1.CurrentX = rotNameX
    Form1.CurrentY = rotNameY
    
    'company name
    'mine is a little strange, with the italics in the middle, so
    'you may want to alter this.
    'NOTE that the semicolon holds the CurrentX and CurrentY at the
    'end of the text, so they stay on the same line.
    Form1.Print "VB";
    Form1.FontItalic = True
    Form1.Print "rainStorm";
    Form1.FontItalic = False
    Form1.Print " Software";
    
    'set up the size, bold, etc.
    Form1.FontBold = False
    Form1.FontSize = 8.25
    Form1.Print ""
    Form1.FontSize = 12
    Form1.FontBold = True
    
    'your name
    Form1.CurrentX = rotNameX
    Form1.CurrentY = Form1.CurrentY + .05 'add a little offset (optional)
    Form1.Print "P. Scott Antony"
    
    'your address
    Form1.FontBold = False
    Form1.FontSize = 9.75
    Form1.CurrentX = rotNameX
    Form1.Print "P.O. Box 11047"
    
    Form1.CurrentX = rotNameX
    Form1.Print "Shorewood, WI  53211"
    
    Form1.CurrentX = rotNameX
    Form1.Print "(414) 963-4770"
    
    'add a blank line
    Form1.Print " "
    'Form1.Print " "
    
    'On "The Net"
    Form1.FontBold = True
    Form1.CurrentX = rotNameX
    Form1.Print "On ""The Net"""
    Form1.FontBold = False
    
    Form1.CurrentX = rotNameX
    Form1.Print "PSAntony@aol.com"
    
    Form1.CurrentX = rotNameX
    Form1.Print "74002.2373@compuserve.com"

End Sub

Sub frmPrintScissors (rBeginX As Double, rBeginY As Double)

    'Print the Scissors Wingding
    On Error Resume Next    'if Wingdings is not installed
    Form1.FontName = "Wingdings"
    If Form1.FontName <> "Wingdings" Then Exit Sub
    Form1.FontBold = False
    Form1.FontSize = 12
    Form1.CurrentX = rBeginX
    Form1.CurrentY = rBeginY - .2
    Form1.Print "#"

End Sub

Sub frmPrintTabText ()
    
    'Enter Text on the Tab (only called if there is a tab requested).
    Form1.FontBold = True
    Form1.FontSize = 12
    'rotTabX and rotTabY were preset in frmPrint_Rotary() while drawing the
    'line. You could also pass them to this routine if you prefer to
    'further modulize it for other tasks.
    Form1.CurrentX = rotTabX
    Form1.CurrentY = rotTabY
    
    'company name
    'mine is a little strange, with the italics in the middle, so
    'you may want to alter this.
    'NOTE that the semicolon holds the CurrentX and CurrentY at the
    'end of the text, so they stay on the same line.
    Form1.Print "VB";
    Form1.FontItalic = True
    Form1.Print "rainStorm";
    Form1.FontItalic = False
    Form1.Print " Software";
    Form1.FontBold = False
    Form1.FontSize = 8.25
    
    'this line does not have a semicolon so CurrentX and CurrentY "feed".
    Form1.Print ""
    Form1.FontSize = 12

End Sub

Sub frmPrintTHole ()
'This subroutine STARTS the T Hole at the CURRENT X and Y positions.

rotCurStyle = Form1.DrawStyle    'grab the current DrawStyle
    
'enable the following line for ALWAYS DOTTED_LINE, or other.
'With this you can place a dotted T hole on a solid frame, or any other
'combination. You could pass this parameter as well if you wish.

'Form1.DrawStyle = DOTTED_LINE
Form1.Line Step(0, 0)-Step(0, -3 / 16)            'up
Form1.Line Step(0, 0)-Step(1 / 16, 0)             'right
Form1.Line Step(0, 0)-Step(0, -5 / 16)            'up
Form1.Line Step(0, 0)-Step(-1 / 4, 0)             'left
Form1.Line Step(0, 0)-Step(0, 5 / 16)             'down
Form1.Line Step(0, 0)-Step(1 / 16, 0)             'right
Form1.Line Step(0, 0)-Step(0, 3 / 16)             'down
    
Form1.DrawStyle = rotCurStyle   'reset to incoming DrawStyle

End Sub

