DEFINT A-Z

DECLARE FUNCTION VPage (p)

FUNCTION VPage (p) STATIC
'****************************************************************************
'This function is used to allocate and release pages of video memory.
'
'To request (allocate) a page, pass zero as the argument.  The function will
' return the page number that has been allocated, or zero if none are left.
'
'To release a video page when your procedure is finished with it, pass the
' page number as the argument to the function.  The function will note the
' page as being available, and will return zero.
'
'The reason behind the function is so that procedures that need to use or
' swap video pages can do so without fear of using a page that may already
' be in use by another procedure.
'
'The function doesn't actually do anything at all with video pages.  It
' merely keeps track of a small array that remembers which pages are in use.
'
'NOTE: This function assumes VGA video with 8 pages (0-7) of video memory for
' screen mode 0.  It also assumes that page 0 is always in use, and does not
' bother to keep track of it.
'
'See function ColorSet() or any of the pop-up box functions for examples of
' use.
'
'****************************************************************************

STATIC page()                           'To keep track of which are in use.

STATIC newdim                           'This is so the array only gets
IF newdim = 0 THEN                      'dimensioned once.
     DIM page(1 TO 7)
     newdim = 1
END IF

free = 0                                'For clarity's sake.
used = 1

SELECT CASE p
     CASE 0                             'Allocate a page
          FOR x = 1 TO 7
               IF page(x) = free THEN        'Returns the number of the page
                    page(x) = used           'that was allocated, or zero if
                    VPage = x                'none were left.
                    EXIT FOR
               END IF
          NEXT x
     CASE ELSE                          'Release the specified page
          page(p) = free
END SELECT

END FUNCTION

