DEFINT A-Z

DECLARE FUNCTION TempName$ (path$)

'External functions:

DECLARE FUNCTION FileExist (f$)
DECLARE FUNCTION Squeeze$ (orig$, char$)
DECLARE FUNCTION Sstr$ (s!)

FUNCTION TempName$ (path$) STATIC
'****************************************************************************
'Used to create a temporary filename.  The filename will reside in the
' specified path, or in the current directory if path$ is null.
'
'The path$ argument may be passed with or without a trailing backslash.
'
'The filename will consist of a leading underscore, the current value of the
' system timer, and an extension of ".TMP".
'
'This standardized naming of temporary files will make it easy to delete any
' leftover temporary files all at once with a wildcard.
'
'    Example filenames:  _4573921.TMP   _230117.TMP
'
'    Example deletion command:  KILL "_*.TMP"
'
'The filename given by TempName$() is stored in a static variable in case the
' function is called more than once in the same 100th of a second (It's not
' as unlikely as you think).  This allows you to get two or more temporary
' filenames without having to create each one before getting the next one.
' The function can produce about 20 filenames per second when called in
' rapid succession.  When called normally (once), I was unable to measure the
' time it took.
'
'See function HomePath$() for an example of use.
'
'****************************************************************************

STATIC prevname$                        'Remember the last one used.

bs$ = "\"                               'For optimization.
us$ = "_"
dot$ = "."
tmp$ = dot$ + "TMP"

p$ = path$                              'Use a temp variable for path$.
IF LEN(p$) THEN
     IF RIGHT$(p$, 1) <> bs$ THEN       'Add a trailing backslash if not
          p$ = p$ + bs$                 'provided & not a null string.
     END IF
END IF

'Find a filename that doesn't already exist in the specified path and isn't
'the same as the last one given:

DO
     temp$ = p$ + us$ + Squeeze$(Sstr$(TIMER), dot$) + tmp$
LOOP UNTIL temp$ <> prevname$ AND NOT FileExist(temp$)

prevname$ = temp$                       'Record the filename for next time.

TempName$ = temp$                       'Return the temporary filename.

END FUNCTION

