DEFINT A-Z

DECLARE SUB TeleType (text$, delay)

SUB TeleType (text$, delay)
'****************************************************************************
'Prints text one character at a time beginning at the current cursor location.
'
'The delay between each character being printed is measured in 1/100ths of a
' second (a delay of 100 would equal one second).  If a value of zero or less
' is specified, the delay defaults to 5/100ths of a second.  If a key is
' pressed during the SUB, the remainder of the string is printed without any
' delay.
'
'You could easily add some sound to this procedure.  I recommend using SOUND
' 20000,1 after each letter except spaces and a delay of at least 7.
'
'****************************************************************************

d! = delay                              'Convert delay from an integer to a
                                        'single precision variable.

IF d! < 1 THEN d! = 5                   'Assign the default delay of 1/20th
                                        'of a second (5/100).

d! = d! / 100                           'Change delay to 100ths of a second.

FOR x = 1 TO LEN(text$)                 'Print text$ one character at a time.
  
     PRINT MID$(text$, x, 1);
  
     now! = TIMER                       'Get the current value of TIMER.
     WHILE TIMER < (now! + d!): WEND    'Wait for TIMER to increase by d!.
  
     IF INKEY$ <> "" THEN d! = 0        'If a key is pressed, stop delaying.

NEXT x

END SUB

