DEFINT A-Z

DECLARE FUNCTION Stuff$ (orig$, position, delnum, char$)

FUNCTION Stuff$ (orig$, position, delnum, char$)
'****************************************************************************
'Inserts and/or deletes character(s) in(to) a string at the specified
' character position.  Very simple, but very useful.
'
'The position argument tells the function where to start its operations upon
' the original.
'
'The delnum argument tells it how many (if any) characters to delete starting
' at that position.
'
'The value of char$ determines what gets put into the string at position.  If
' null, nothing will get put in, effectively deleting characters from within
' the string.
'
'Examples: Stuff$("QBasic",2,0,"uick") --> "QuickBasic" (Adds characters)
'          Stuff$("Landlocked",5,4,"") --> "Landed"     (Deletes characters)
'          Stuff$("Trifle",4,1,"bb")   --> "Tribble"    (Replaces characters)
'
'Specifying a delnum of zero and a null char$ will do nothing.
'
'****************************************************************************

part1$ = LEFT$(orig$, position - 1)     'Break the string into two parts at
part2$ = MID$(orig$, position + delnum) 'the specified position, skipping any
                                        'characters to be deleted.

Stuff$ = part1$ + char$ + part2$        'Rebuild the string, including char$
                                        'between the two parts.
END FUNCTION

