DEFINT A-Z

DECLARE FUNCTION Strip$ (orig$, side, char$)

FUNCTION Strip$ (orig$, side, char$)
'****************************************************************************
'Strips leading and/or trailing characters from a string.  It works like
' LTRIM$() and RTRIM$() but on other characters in addition to spaces.
'
'The side argument is passed in one of the following ways:
'
'    <0 = Strip the left side
'     0 = Strip both sides
'    >0 = Strip the right side
'
'Combinations of characters can also be stripped from each side as well as
' individual characters.  In this case, the length of char$ would be greater
' than one.  The characters to be stripped ARE case sensitive.
'
'Examples:     Strip$("00100",-1, "0")  -->  "100"
'              Strip$("AABAa", 0, "A")  -->  "BAa"
'              Strip$("00100", 0, "0")  -->  "1"
'              Strip$("     ", 0, " ")  -->  ""
'              Strip$("ABCDE", 0, "AB") -->  "CDE"
'              Strip$("ABCDE", 1, "AB") -->  "ABCDE"
'
'****************************************************************************

IF orig$ = "" OR char$ = "" THEN        'If either argument is a null string,
     Strip$ = orig$                     'return the original because nothing
     EXIT FUNCTION                      'can be stripped from a null string,
END IF                                  'and you can't search for a null.

l = LEN(char$)                          'Find the length of the char(s) to
                                        'strip.

new$ = orig$                            'Don't alter the original.

IF side <= 0 THEN                       'Strip the left side.  Notice how
     DO WHILE LEFT$(new$, l) = char$    'both sides will get stripped if side
          new$ = MID$(new$, l + 1)      'is equal to zero.
     LOOP
END IF

IF side >= 0 THEN                       'Strip the right side.
     DO WHILE RIGHT$(new$, l) = char$
          new$ = LEFT$(new$, LEN(new$) - (l + 1))
     LOOP
END IF

Strip$ = new$                           'Return the stripped string.

END FUNCTION

