DEFINT A-Z

DECLARE FUNCTION Squeeze$ (orig$, char$)

FUNCTION Squeeze$ (orig$, char$)
'****************************************************************************
'Removes all occurrences of a substring from within a string.
'
'Example: Squeeze$("Peter Piper","er") --> "Pet Pip"
'
'****************************************************************************

IF orig$ = "" OR char$ = "" THEN        'If either argument is a null string,
     Squeeze$ = orig$                   'return the original because nothing
     EXIT FUNCTION                      'can be squeezed from a null string
END IF                                  'and INSTR always returns 1 when
                                        'searching for a null string.

new$ = orig$                            'Don't alter the original in case the
                                        'calling program still needs it!

DO WHILE INSTR(new$, char$) > 0         'Loop until char$ is no longer found.
  
     x = INSTR(new$, char$)             'Find the location of char$.
     l$ = LEFT$(new$, x - 1)            'Get the part to the left of char$.
     r$ = MID$(new$, x + LEN(char$))    'Get the part to the right of char$.
     new$ = l$ + r$                     'Put the string back together without
                                        'char$!
LOOP

Squeeze$ = new$                         'Return the squeezed string

END FUNCTION

