DEFINT A-Z

DECLARE SUB Spread (text$, row, col, delay)

SUB Spread (text$, row, col, delay)
'****************************************************************************
'Spreads text on the screen in both directions starting from the specified
'coordinates.  Delay is measured in 100ths of a second.
'****************************************************************************

d! = delay                              'Convert delay from an integer to a
                                        'single precision variable.

IF d! < 1 THEN d! = 5                   'Assign the default delay of 1/20th
                                        'of a second (5/100).

d! = d! / 100                           'Change delay to 100ths of a second.

IF text$ = "" THEN EXIT SUB             'Quit if text$ is a null string.

txt$ = text$                            'Use a temp variable to modify text$.

IF LEN(txt$) MOD 2 = 1 THEN             'If the length of text$ is not even,
     txt$ = txt$ + " "                  'add a space to make it even.
END IF

lt$ = LEFT$(txt$, LEN(txt$) \ 2)        'Break it into left & right sides.
rt$ = RIGHT$(txt$, LEN(txt$) \ 2)

FOR x = 1 TO LEN(rt$)                   'Could also use lt$, they're equal.

     LOCATE row, col                    'Print a letter from the right side.
     PRINT RIGHT$(rt$, x);
  
     IF (col - x) >= 1 THEN             'Only print the left side while the
                                        'value of column is still valid.
          LOCATE row, col - x
          PRINT LEFT$(lt$, x);          'Print a letter from the left side.
     END IF

     now! = TIMER                       'Get current value of TIMER.
     WHILE TIMER < (now! + d!): WEND    'Wait for timer to increase by d!

     IF INKEY$ <> "" THEN d! = 0        'If a key is pressed, stop delaying.

NEXT x

END SUB

