DEFINT A-Z

DECLARE SUB Slide (text$, lr, row, col, delay)

SUB Slide (text$, lr, row, col, delay)
'****************************************************************************
'Slides text onto the screen to the left or right starting at the specified
' row and column.
'
'The direction is determined by the argument lr, where a zero value equals
' left, non-zero equals right.
'
'delay is measured in 100ths of a second.
'
'****************************************************************************

d! = delay                              'Convert delay from an integer to a
                                        'single precision variable.

IF d! < 1 THEN d! = 5                   'Assign the default delay of 1/20th
                                        'of a second (5/100).

d! = d! / 100                           'Change delay to 100ths of a second.

FOR x = 1 TO LEN(text$)

     IF lr = 0 THEN                     'Slide to the left
         
          IF (col - x + 1) < 1 THEN          'If the column position becomes
               EXIT FOR                      'illegal (0 or less), stop.
          END IF

          LOCATE row, col - x + 1            'Print one character at a time,
          PRINT LEFT$(text$, x);             'from left to right.
    
     ELSE                               'Slide to the right
    
          LOCATE row, col                    'Print one character at a time,
          PRINT RIGHT$(text$, x);            'from right to left.

     END IF

     now! = TIMER                       'Get current value of TIMER.
     WHILE TIMER < (now! + d!): WEND    'Wait for timer to increase by d!

     IF INKEY$ <> "" THEN d! = 0        'If a key is pressed, stop delaying.

NEXT x

END SUB

