DEFINT A-Z

' $INCLUDE: 'PARM.INC'

DECLARE SUB SetView (top, bot, parm())

SUB SetView (top, bot, parm()) STATIC
'****************************************************************************
'Used to set the current text viewport (VIEW PRINT) and update the changes in
' the parm() array.
'
'To change the current viewport settings, pass the appropriate values in the
' top and/or bot arguments.  Setting both values to zero will have the effect
' of releasing the active VIEW PRINT setting and restoring the viewport to
' the entire screen.
'
'To reset the the viewport to the values currently stored in parm() without
' changing either value, pass negative numbers for both arguments.
'
'Examples:  SetView  0,  0, parm()  -->  Sets viewport to the entire screen.
'           SetView  4, 24, parm()  -->  Sets viewport to rows 4 through 24.
'           SetView  6,  0, parm()  -->  Updates the top row of the viewport
'                                         to 6, leaving the current value for
'                                         the bottom row unchanged.
'           SetView -1, -1, parm()  -->  Resets the viewport to the values
'                                         currently stored in parm() without
'                                         changing either value.
'
'****************************************************************************

z = 0                                   'For optimization.

IF top > z THEN                         'Set new top value.
     parm(VPTOP) = top
END IF
IF bot > z THEN                         'Set new bottom value.
     parm(VPBOT) = bot
END IF
IF top = z AND bot = z THEN             'Reset viewport to entire screen if
     parm(VPTOP) = z                    'both arguments are zero.
     parm(VPBOT) = z
END IF

IF parm(VPTOP) = z OR parm(VPBOT) = z THEN
     VIEW PRINT
ELSE
     VIEW PRINT parm(VPTOP) TO parm(VPBOT)
END IF

END SUB

