DEFINT A-Z

' $INCLUDE: 'SETCURS.INC'

'(The function declaration is in the include file)

FUNCTION SetCursor (cursortype) STATIC
'****************************************************************************
'A set/get function for turning the cursor on and off and changing its
' appearance.
'
'Be sure to include the SETCURS.INC in the calling program and use its
' constants as arguments to the function.
'
'To inquire on the current setting without changing it, pass a negative
' number as an argument (or anything besides one of the defined constants).
'
'****************************************************************************

STATIC cursor
SetCursor = cursor                 'Retain previous value to return

SELECT CASE cursortype
     CASE SCNONE                   'None - turn it off
          LOCATE , , 0
          cursor = cursortype
     CASE SCINS                    'Insert - underscore cursor
          LOCATE , , 1, 7
          cursor = cursortype
     CASE SCOVR                    'Overwrite - block cursor
          LOCATE , , 1, 0, 7
          cursor = cursortype
     CASE ELSE
          'Inquiry only
END SELECT

END FUNCTION

