DEFINT A-Z

DECLARE SUB SaveScreen (filename$)
DECLARE SUB RestScreen (filename$)

SUB RestScreen (filename$)
'****************************************************************************
'Restores a screen saved by SaveScreen().
'
'You should only pass a filename that you know contains data created by the
' SaveScreen() sub.  I have no idea what would happen if you used any other
' kind of data.  Use at your own risk.  If you pass a filename that does not
' exist, a run-time error will occur.
'
'****************************************************************************

VS& = PEEK(&H63) + PEEK(&H64) * 256     'Get CRT controller port

IF VS& = &H3B4 THEN
     VS& = &HB000                       'Video RAM segment address (mono)
ELSE
     VS& = &HB800                       'Video RAM segment address (color)
END IF

DEF SEG = VS&
BLOAD filename$, 0
DEF SEG

END SUB

SUB SaveScreen (filename$)
'****************************************************************************
'Saves the current text screen to the specified binary file.  If the file
' already exists, it will be overwritten.
'
'This function was only tested in text mode (SCREEN 0).  I have no idea what
' it would do in any other screen mode.  Use at your own risk.
'
'****************************************************************************

VS& = PEEK(&H63) + PEEK(&H64) * 256     'Get CRT controller port

IF VS& = &H3B4 THEN
     VS& = &HB000                       'Video RAM segment address (mono)
ELSE
     VS& = &HB800                       'Video RAM segment address (color)
END IF

DEF SEG = VS&
BSAVE filename$, 0, 4000
DEF SEG

END SUB

