DEFINT A-Z

DECLARE FUNCTION Rinstr (start, search$, lookfor$)

FUNCTION Rinstr (start, search$, lookfor$)
'****************************************************************************
'Kind of a "Reverse INSTR" (hence the name).  Returns the character position
' of the LAST occurrence of a substring within another.
'
'If the start argument is greater than zero, search$ is truncated to
' (start-1) before the search begins (I would rather have called it "end" but
' that word is taken).  The start argument is especially useful for
' subsequent calls to Rinstr, i.e., to find the second-to-last occurrence,
' etc.
'
'Examples:  Rinstr(0,"Peter Piper","er")  --> 10
'           Rinstr(10,"Peter Piper","er") --> 4  (Searches "Peter Pip")
'
'****************************************************************************

IF search$ = "" OR lookfor$ = "" THEN   'If either argument is a null string,
     Rinstr = 0                         'return zero.  (I hate that INSTR
     EXIT FUNCTION                      'returns a 1 when you search for a
END IF                                  'null string!)

IF start > LEN(search$) OR start < 0 THEN    'Return zero if start is greater
     Rinstr = 0                              'than the length of search$ or
     EXIT FUNCTION                           'is negative.
END IF

IF start > 0 THEN                       'If start > 0, chop the string at
     s$ = LEFT$(search$, start - 1)     'that position so we don't bother
ELSE                                    'searching past it.
     s$ = search$                       'Otherwise, just use the original.
END IF

last = 0
x = INSTR(s$, lookfor$)                      'Get the first occurrence.

WHILE x > 0                                  'Go through the string,
     last = x                                'increasing the starting
     x = INSTR((last + 1), s$, lookfor$)     'position each time the
WEND                                         'substring is found.

Rinstr = last            'Return the position of the rightmost occurrence.

END FUNCTION

