DEFINT A-Z

' $INCLUDE: 'PARM.INC'
' $INCLUDE: 'SETCURS.INC'
' $INCLUDE: 'TRUEFALS.INC'

DECLARE SUB Progress (cur, msg$(), parm())


'External procedures:

DECLARE SUB BoxCalc (t, l, b, r, tall, wide)
DECLARE SUB PopBox (t, l, b, r, wide, msg$(), parm())
DECLARE SUB RestScreen (f$)
DECLARE SUB SaveScreen (f$)
DECLARE SUB SetView (t, b, parm())
DECLARE FUNCTION TempName$ (p$)
DECLARE FUNCTION VPage (p)

SUB Progress (cur, msg$(), parm()) STATIC
'****************************************************************************
'Displays a percentage progress bar in a pop-up box.  The actual numeric
' progress is also shown.  The progress bar is updated in 5% increments.
'
'    parm(1) = top left row  0=Center
'    parm(2) = top left column  0=Center
'    parm(3) = box border type 1-4.  See SUB Panes() for numeric boxtypes.
'    parm(4) = message justification  <0=Left  0=Center  >0=Right
'    parm(5) = maximum: (cur/maximum)*100 = percentage complete
'
'The function has three different uses.  The first will draw the box on the
' screen.  The second usage will update the progress bar in the currently
' displayed box.  The third will remove the box from the screen.
'
'The cur argument is used to indicate what you want Progress() to do:
'
'    0 = New box
'   >0 = Update current box  (cur/maximum)*100 = %
'   <0 = Remove box
'
'Only one box may be on screen at any one time.  If you specify an operation
' that conflicts with the current status of the sub (like requesting a new
' box when there's already one up) nothing will happen.
'
'Once the box is on screen, you should not do any PRINTing.  This should not
' be a problem, as the main usage for this function is for when some major
' processing is going on and you want the user to know that their computer
' is actually doing something.
'
'Another feature of Progress() is the fact that it will always appear for at
' least 1.5 seconds.  Have you ever used a program & had some message flash
' by before you got a chance to read it?  Pretty annoying, isn't it.
'
'****************************************************************************

STATIC oldrow                           'These must be kept to restore the
STATIC oldcol                           'screen when finished.
STATIC oldcursor
STATIC savepage
STATIC savefile$

STATIC onscreen                         'Is there already a box on screen?
STATIC pstart!                          'When was the box put up?

STATIC brow                             'These must be kept to avoid
STATIC bcol                             'recalculating them every update.

STATIC bar$                             'Might as well keep this too.

SELECT CASE cur                                        'What are we doing?
     CASE 0                                  'A new box:
          IF onscreen THEN EXIT SUB
          bar$ = ""
          wide = LEN(bar$) + 2
          tall = 3
          FOR x = LBOUND(msg$) TO UBOUND(msg$)         'For comments on this
               l = LEN(msg$(x))                        'section, see the
               IF l > wide THEN wide = l               'other box functions.
               tall = tall + 1
          NEXT x
          row1 = parm(1)
          col1 = parm(2)
          BoxCalc row1, col1, row2, col2, tall, wide
          l = LEN(bar$) + 2
          IF wide = l THEN
               bcol = col1 + 1
          ELSE
               bcol = col1 + 1 + ((wide - l) \ 2)
          END IF
          brow = row2 - 2
          oldrow = CSRLIN
          oldcol = POS(0)
          oldcursor = SetCursor(SCNONE)
          savepage = VPage(0)
          IF savepage = 0 THEN
               savefile$ = TempName$("")
               SaveScreen savefile$
          ELSE
               PCOPY 0, savepage
          END IF
          PopBox row1, col1, row2, col2, wide, msg$(), parm()
          onscreen = TRUE
          pstart! = TIMER

     CASE IS > 0                             'Update the current box:
          IF NOT onscreen THEN EXIT SUB
          COLOR parm(FGWT), parm(BGWT)
          p = INT((cur / parm(5)) * 100)
          LOCATE brow + 1, bcol + 8
          PRINT USING "###"; p;
          p = p \ 5
          LOCATE brow, bcol
          PRINT STRING$(p, 223); MID$(bar$, p + 1);

     CASE ELSE                               'Remove the box:
          IF NOT onscreen THEN EXIT SUB
          DO WHILE TIMER < pstart! + 1.5     'Make sure the box appears for
          LOOP                               'at least 1.5 seconds.
          IF savepage = 0 THEN
               RestScreen savefile$
               KILL savefile$
          ELSE
               PCOPY savepage, 0
               x = VPage(savepage)
          END IF
          x = SetCursor(oldcursor)
          COLOR parm(FGN), parm(BGN)
          SetView -1, -1, parm()
          LOCATE oldrow, oldcol
          onscreen = FALSE

END SELECT

END SUB

