DEFINT A-Z

' $INCLUDE: 'PARM.INC'

DECLARE SUB PopBox (t, l, b, r, wide, msg$(), parm())


'External procedures:

DECLARE SUB Box (t, l, b, r, b$)
DECLARE FUNCTION Istr$ (i)
DECLARE FUNCTION PadC$ (t$, l)
DECLARE FUNCTION PadL$ (t$, l)
DECLARE FUNCTION PadR$ (t$, l)
DECLARE FUNCTION VPage (p)
DECLARE SUB WipeArea (t, l, b, r)

SUB PopBox (t, l, b, r, wide, msg$(), parm())
'****************************************************************************
'This function is used by other pop-up box functions to zap the box onto the
' screen.  The procedure that calls this function must have its parm(3 & 4)
' arguments set up like so:
'
'    parm(3) = box border type 1-4
'    parm(4) = message justification  <0=Left  0=Center  >0=Right
'
'See EditBox(), PickBox(), and Progress() for examples of use.  ListBox() is
' not included because it doesn't have a msg$() array.
'
'****************************************************************************

workpage = VPage(0)                     'Allocate a non-critical video page.
PCOPY 0, workpage                       'Copy the screen to the scratch page.
SCREEN , , workpage, 0                  'Draw on the work page until ready.

COLOR parm(FGWB), parm(BGWB)            'Draw the outline
Box t, l, b, r, Istr$(parm(3))

COLOR parm(FGWT), parm(BGWT)            'Print the text.
WipeArea t + 1, l + 1, b - 1, r - 1
y = t
FOR x = LBOUND(msg$) TO UBOUND(msg$)
     y = y + 1
     LOCATE y, l + 1
     SELECT CASE parm(4)                'Justify the text.
          CASE IS < 0
               PRINT PadR$(msg$(x), wide)
          CASE 0
               PRINT PadC$(msg$(x), wide)
          CASE ELSE
               PRINT PadL$(msg$(x), wide)
     END SELECT
NEXT x

COLOR 0, 0                              'Print the shadow
y = r + 1
FOR x = (t + 1) TO b
     LOCATE x, y: PRINT " ";
NEXT x
LOCATE b + 1, l + 1: PRINT SPACE$(wide + 2);

PCOPY workpage, 0                       'Pop the box onto the screen.
SCREEN , , 0, 0                         'Draw on screen 0 again.
x = VPage(workpage)                     'Release the scratch video page.

COLOR parm(FGWT), parm(BGWT)            'Reset the colors to window text.

END SUB

