DEFINT A-Z

' $INCLUDE: 'PARM.INC'
' $INCLUDE: 'SETCURS.INC'
' $INCLUDE: 'TRUEFALS.INC'

DECLARE FUNCTION PickSome$ (choice$(), tag(), parm())

'External procedures:

DECLARE SUB BorderLines (parm())
DECLARE FUNCTION GetKey$ (parm())
DECLARE FUNCTION Istr$ (i)
DECLARE FUNCTION PadR$ (orig$, newlen)
DECLARE SUB WipeArea (t, l, b, r)

FUNCTION PickSome$ (choice$(), tag(), parm())
'****************************************************************************
'PickSome$() works just like the PickOne$() function but also allows for the
' tagging of multiple items.  See PickOne$() for general information about
' how these functions work.  Additional information on how the tagging works
' is described here.
'
'    parm(1) = top row
'    parm(2) = bottom row
'    parm(3) = column width  0=Calculated by the function (recommended)
'    parm(4) = initial selected element #
'    parm(5) = reset  0=Subsequent call  Non-zero=Reset
'    parm(6) = tagging key  Default=32 (spacebar)
'    parm(7) = tag all key  Default=-66 (F8)
'    parm(8) = tag none key  Default=-67 (F9)
'    parm(9) = switch tags key  Default=-68 (F10)
'    parm(10) can be specified as another hotkey (see PickOne$())
'
'The tagging keys specified by parm(6 to 9) may be disabled by passing -1.
' The default will be assigned if zero is passed.
' The tagging key will toggle an individual item's tag to on (1) or off (0).
' The tag all/tag none keys will set all items' tags to on/off respectively.
' The switch tags key will change all on tags to off, and all off tags to on.
'
'The tag array must be an integer array with subscripts identical to the
' choice$() array.  You may pre-tag items or disable items in the array by
' setting elements of tag() to one of the following values:
'
'            0 = Untagged/Off   1 = Tagged/On   -1 = Disabled
'
'If an item is disabled, it will be unaffected by any tagging operations and
' will appear in the dimmed color specified by parm(FGD) and/or parm(FGDS).
'
'****************************************************************************

STATIC top                              'To restore for a subsequent call.

oldcursor = SetCursor(SCNONE)           'Turn the cursor off

IF parm(10) > 0 THEN                    'Hotkey specified?
     hotkey$ = CHR$(parm(10))
ELSEIF parm(10) < 0 THEN
     hotkey$ = CHR$(0) + CHR$(-parm(10))
END IF

x = parm(6)                             'Set up the tagging keys
IF x = 0 THEN x = 32     'Default = spacebar
GOSUB MakeTagKey
tagkey$ = k$
x = parm(7)
IF x = 0 THEN x = -66    'Default = F8
GOSUB MakeTagKey
allkey$ = k$
x = parm(8)
IF x = 0 THEN x = -67    'Default = F9
GOSUB MakeTagKey
nonekey$ = k$
x = parm(9)
IF x = 0 THEN x = -68    'Default = F10
GOSUB MakeTagKey
switchkey$ = k$

REDIM t$(-1 TO 1)                       'Set up the tagging identifiers
t$(-1) = " "
t$(0) = " "
t$(1) = CHR$(251)

min = LBOUND(choice$)                   'Get information about choice$().
max = UBOUND(choice$)

REDIM temp(1 TO MAXPARM)                'Create a duplicate parameter array
FOR x = MINPARM TO MAXPARM              'for calling the BorderLines() SUB.
     temp(x) = parm(x)
NEXT x
temp(1) = parm(1)
temp(2) = parm(2)
temp(5) = min
temp(6) = max

wide = parm(3)                          'Calculate column widths, increasing
IF wide < 1 THEN                        ' the given or calculated value by 2
     FOR x = min TO max                 ' to allow for separating spaces and
          l = LEN(choice$(x)) + 2       ' the tag character.
          IF l > wide THEN wide = l
     NEXT x
ELSE
     wide = wide + 2
END IF
IF wide > 80 THEN wide = 80
DO WHILE (80 MOD wide) > 0              'Make the columns fill the screen.
     wide = wide + 1
LOOP
cols = 80 \ wide                        'Calculate # of columns

tall = parm(2) - parm(1) - 1            'Calculate # of items per column.
ptot = cols * tall                      'Calculate # of items per screen.

sel = parm(4)                           'Determine initial selected element.
IF sel < min THEN sel = min
IF sel > max THEN sel = max


IF parm(5) THEN top = min               'Was top Reset?  Is it valid?
IF top < min OR top > max THEN top = min
bot = top + ptot - 1

IF sel < top OR sel > bot THEN          'Move top & bot to fit sel if they
     top = min                          'don't already do so.
     bot = top + ptot - 1
END IF
DO WHILE sel > bot
     top = top + ptot
     bot = top + ptot - 1
LOOP
IF bot > max THEN bot = max

'    *************************  The Main Loop!  *************************

l = wide - 2                            'To allow for the separating spaces
                                        ' and the tag when padding the items.

refresh = TRUE                          'Make sure the screen gets drawn!

DO

     IF refresh THEN                    'This stuff only needs to be printed
          temp(3) = top                 ' occasionally (i.e., when top & bot
          temp(4) = bot                 ' change).
          BorderLines temp()
          WipeArea parm(1) + 1, 1, parm(2) - 1, 80
          refresh = FALSE
     END IF

     row = parm(1) + 1: col = 1         'Show the items on screen
     FOR x = top TO bot
          IF tag(x) = -1 THEN COLOR parm(FGD)
          IF x = sel THEN
               COLOR parm(FGS), parm(BGS)
               IF tag(x) = -1 THEN COLOR parm(FGDS)
          END IF
          LOCATE row, col: PRINT " "; PadR$(choice$(x), l); t$(tag(x))
          COLOR parm(FGN), parm(BGN)
          row = row + 1
          IF row = parm(2) THEN row = parm(1) + 1: col = col + wide
     NEXT x

     k$ = UCASE$(GetKey$(parm()))       'Get keyboard input

     SELECT CASE ASC(LEFT$(k$, 1))
          CASE 13                                           'Enter
               PickSome$ = Istr$(sel)
               EXIT DO
          CASE 27                                           'ESC
               PickSome$ = ""
               EXIT DO
          CASE 0
               SELECT CASE ASC(RIGHT$(k$, 1))
                    CASE 72                                 'Up Arrow
                         sel = sel - 1
                    CASE 80                                 'Down Arrow
                         sel = sel + 1
                    CASE 75                                 'Left Arrow
                         IF cols > 1 THEN
                              sel = sel - tall
                              IF sel < top THEN
                                   sel = sel + ptot
                              END IF
                         END IF
                    CASE 77                                 'Right Arrow
                         IF cols > 1 THEN
                              sel = sel + tall
                              IF sel > bot THEN
                                   sel = sel - ptot
                              END IF
                         END IF
                    CASE 73                                 'PgUp
                         IF top > min THEN
                              top = top - ptot
                              IF top < min THEN top = min
                              bot = top + ptot - 1
                              IF bot > max THEN bot = max
                              sel = top
                              refresh = TRUE
                         END IF
                    CASE 81                                 'PgDn
                         IF bot < max THEN
                              top = top + ptot
                              bot = top + ptot - 1
                              IF bot > max THEN bot = max
                              sel = top
                              refresh = TRUE
                         END IF
                    CASE 71                                 'Home
                         sel = min
                         IF top > min THEN
                              top = min
                              bot = top + ptot - 1
                              IF bot > max THEN bot = max
                              refresh = TRUE
                         END IF
                    CASE 79                                 'End
                         sel = max
                         IF bot < max THEN
                              bot = max
                              top = bot - ptot + 1
                              IF top < min THEN top = min
                              refresh = TRUE
                         END IF
                    CASE ELSE                               'TagKey/Hotkey?
                         GOSUB HotKeys
               END SELECT
          CASE ELSE
               GOSUB HotKeys
     END SELECT

     IF sel < top THEN sel = bot
     IF sel > bot THEN sel = top

LOOP

x = SetCursor(oldcursor)                'Restore cursor to previous setting.
ERASE t$                                'Relinquish array memory.
ERASE temp

EXIT FUNCTION                           'Avoid a RETURN WITHOUT GOSUB error!

HotKeys:
     SELECT CASE k$
          CASE tagkey$
               IF tag(sel) <> -1 THEN
                    tag(sel) = tag(sel) + 1
                    IF tag(sel) > 1 THEN tag(sel) = 0
                    sel = sel + 1
               END IF
          CASE allkey$
               FOR x = min TO max
                    IF tag(x) <> -1 THEN
                         tag(x) = 1
                    END IF
               NEXT x
          CASE nonekey$
               FOR x = min TO max
                    IF tag(x) <> -1 THEN
                         tag(x) = 0
                    END IF
               NEXT x
          CASE switchkey$
               FOR x = min TO max
                    IF tag(x) <> -1 THEN
                         tag(x) = tag(x) + 1
                         IF tag(x) > 1 THEN tag(x) = 0
                    END IF
               NEXT x
          CASE hotkey$                       'User-defined hotkey?
               PickSome$ = "*" + Istr$(parm(10)) + " " + Istr$(sel)
               x = SetCursor(oldcursor)
               ERASE t$
               ERASE temp
               EXIT FUNCTION
          CASE ELSE
               'Do nothing
     END SELECT
     RETURN

MakeTagKey:
     IF x = -1 THEN                     'Disable this key
          k$ = ""
     ELSEIF x > 0 THEN                  'One-byte key
          k$ = CHR$(x)
     ELSE                               'Two-byte key
          k$ = CHR$(0) + CHR$(-x)
     END IF
     RETURN

END FUNCTION

