DEFINT A-Z

' $INCLUDE: 'PARM.INC'
' $INCLUDE: 'SETCURS.INC'
' $INCLUDE: 'TRUEFALS.INC'

DECLARE FUNCTION PickOne$ (choice$(), parm())

'External procedures:

DECLARE SUB BorderLines (parm())
DECLARE FUNCTION GetKey$ (parm())
DECLARE FUNCTION Istr$ (i)
DECLARE FUNCTION PadR$ (orig$, newlen)
DECLARE SUB WipeArea (t, l, b, r)

FUNCTION PickOne$ (choice$(), parm())
'****************************************************************************
'Allow the user to select an item from an array by highlighting it with the
' cursor keys & pressing Enter.  The function returns a string of the item's
' element number, or a null string if the user ESCapes.  Other options are
' available, and are specified in parm().
'
'    parm(1) = top row
'    parm(2) = bottom row
'    parm(3) = column width  0=Calculated by the function (recommended)
'    parm(4) = initial selected element #
'    parm(5) = reset?  0=Subsequent call  Non-zero=Reset
'
'Any column width specified in parm(3) will be increased by 2 to allow for
' spaces on either side of each item.  Allow for this when supplying this
' value.
'
'parm(6 to 10) are special parameters, designating "hotkeys" that will return
' control to the calling procedure, and return a string of the key pressed
' along with the element number of the currently highlighted item.  If no
' hotkey is desired, merely pass a zero for that parameter.
'
'To specify a one-byte INKEY$ code, merely pass the ASCII code of the key.
' If the key is a letter, pass the upper-case ASCII code.  To specify a two-
' byte key, pass the negative ASCII code of the second byte.
'
' Examples:  To specify the backspace key, pass 8 ( CHR$(8) ).
'            To specify the F1 key, pass -59 ( CHR$(0)+CHR$(59) ).
'
'The string returned when a hotkey is pressed will consist of an asterisk
' followed by the hotkey code specified in the parm() array, a space, and the
' current element number.
'
' Example: "*-59 4" would mean that the F1 key was pressed while element #4
'          was highlighted.
'
'When returning to the function after processing a hotkey, make sure that
' parm(4) is updated to reflect the current element, and parm(5) is zero.
' If calling the function for the first time, make sure parm(5) is non-zero.
'
'****************************************************************************

STATIC top                              'To preserve the position of the pick
                                        'screen between calls.

oldcursor = SetCursor(SCNONE)           'Turn the cursor off

REDIM hotkey$(6 TO 10)                  'Evaluate parm() for hotkeys.
FOR x = 6 TO 10
     IF parm(x) > 0 THEN
          hotkey$(x) = CHR$(parm(x))
     ELSEIF parm(x) < 0 THEN
          hotkey$(x) = CHR$(0) + CHR$(-parm(x))
     END IF
NEXT x

min = LBOUND(choice$)                   'Get information about choice$().
max = UBOUND(choice$)

REDIM temp(1 TO MAXPARM)                'Create a duplicate parameter array
FOR x = MINPARM TO MAXPARM              'for calling the BorderLines() SUB.
     temp(x) = parm(x)
NEXT x
temp(1) = parm(1)
temp(2) = parm(2)
temp(5) = min
temp(6) = max

wide = parm(3)                          'Calculate column widths, increasing
IF wide < 1 THEN                        ' the given or calculated value by 2
     FOR x = min TO max                 ' to allow for separating spaces.
          l = LEN(choice$(x)) + 2
          IF l > wide THEN wide = l
     NEXT x
ELSE
     wide = wide + 2
END IF
IF wide > 80 THEN wide = 80
DO WHILE (80 MOD wide) > 0              'Make the columns fill the screen.
     wide = wide + 1
LOOP
cols = 80 \ wide                        'Calculate # of columns

tall = parm(2) - parm(1) - 1            'Calculate # of items per column.
ptot = cols * tall                      'Calculate # of items per screen.

sel = parm(4)                           'Determine initial selected element.
IF sel < min THEN sel = min
IF sel > max THEN sel = max

IF parm(5) THEN top = min               'Was top Reset?  Is it valid?
IF top < min OR top > max THEN top = min
bot = top + ptot - 1

IF sel < top OR sel > bot THEN          'Move top & bot to fit sel.
     top = min
     bot = top + ptot - 1
END IF
DO WHILE sel > bot
     top = top + ptot
     bot = top + ptot - 1
LOOP
IF bot > max THEN bot = max

'    *************************  The Main Loop!  *************************

l = wide - 2                            'To allow for the separating spaces
                                        ' when padding the items.

refresh = TRUE                          'Make sure the screen gets drawn!

DO

     IF refresh THEN                    'This stuff only needs to be printed
          temp(3) = top                 ' occasionally (i.e., when top & bot
          temp(4) = bot                 ' change).
          BorderLines temp()
          WipeArea parm(1) + 1, 1, parm(2) - 1, 80
          refresh = FALSE
     END IF

     row = parm(1) + 1: col = 1         'Show the items on screen
     FOR x = top TO bot
          IF x = sel THEN COLOR parm(FGS), parm(BGS)
          LOCATE row, col: PRINT " "; PadR$(choice$(x), l); " "
          COLOR parm(FGN), parm(BGN)
          row = row + 1
          IF row = parm(2) THEN row = parm(1) + 1: col = col + wide
     NEXT x

     k$ = UCASE$(GetKey$(parm()))       'Get keyboard input
     SELECT CASE ASC(LEFT$(k$, 1))
          CASE 13                                           'Enter
               PickOne$ = Istr$(sel)
               EXIT DO
          CASE 27                                           'ESC
               PickOne$ = ""
               EXIT DO
          CASE 0
               SELECT CASE ASC(RIGHT$(k$, 1))
                    CASE 72                                 'Up Arrow
                         sel = sel - 1
                    CASE 80                                 'Down Arrow
                         sel = sel + 1
                    CASE 75                                 'Left Arrow
                         IF cols > 1 THEN
                              sel = sel - tall
                              IF sel < top THEN
                                   sel = sel + ptot
                              END IF
                         END IF
                    CASE 77                                 'Right Arrow
                         IF cols > 1 THEN
                              sel = sel + tall
                              IF sel > bot THEN
                                   sel = sel - ptot
                              END IF
                         END IF
                    CASE 73                                 'PgUp
                         IF top > min THEN
                              top = top - ptot
                              IF top < min THEN top = min
                              bot = top + ptot - 1
                              IF bot > max THEN bot = max
                              sel = top
                              refresh = TRUE
                         END IF
                    CASE 81                                 'PgDn
                         IF bot < max THEN
                              top = top + ptot
                              bot = top + ptot - 1
                              IF bot > max THEN bot = max
                              sel = top
                              refresh = TRUE
                         END IF
                    CASE 71                                 'Home
                         sel = min
                         IF top > min THEN
                              top = min
                              bot = top + ptot - 1
                              IF bot > max THEN bot = max
                              refresh = TRUE
                         END IF
                    CASE 79                                 'End
                         sel = max
                         IF bot < max THEN
                              bot = max
                              top = bot - ptot + 1
                              IF top < min THEN top = min
                              refresh = TRUE
                         END IF
                    CASE ELSE                               'Hotkey?
                         GOSUB HotKeys
               END SELECT
          CASE ELSE
               GOSUB HotKeys
     END SELECT

     IF sel < top THEN sel = bot
     IF sel > bot THEN sel = top

LOOP

x = SetCursor(oldcursor)                'Restore cursor to previous setting
ERASE hotkey$                           'Relinquish array memory
ERASE temp

EXIT FUNCTION                           'Avoid a RETURN WITHOUT GOSUB error!

HotKeys:
     FOR x = 6 TO 10
          IF k$ = hotkey$(x) THEN
               PickOne$ = "*" + Istr$(parm(x)) + " " + Istr$(sel)
               x = SetCursor(oldcursor)
               ERASE hotkey$
               ERASE temp
               EXIT FUNCTION
          END IF
     NEXT x
     RETURN

END FUNCTION

