DEFINT A-Z

DECLARE FUNCTION PickInfo$ (p$, k, e)

FUNCTION PickInfo$ (p$, k, e)
'****************************************************************************
'This function interprets the return string from the PickOne$() and
' PickSome$() functions.
'
'The return value from the Pick function is passed as p$.  The integer
' variables passed as k and e will be assigned the value of the keypress and
' element number respectively.
'
'PickInfo$() returns the actual character value of the keypress used to exit
' the Pick function.
'
'See the comments within PickOne$() for a more detailed explanation of the
' Pick functions' return values.
'
'Examples:     k$ = PickInfo$("", k, e)        -->  k$ = CHR$(27)
'                                                   k  = 27
'              (User pressed ESC)                   e  = 0
'
'              k$ = PickInfo$("*-59 4", k, e)  -->  k$ = CHR$(0)+CHR$(59)
'                                                   k  = -59
'              (User pressed F1 on element 4)       e  = 4
'
'              k$ = PickInfo$("19", k, e)      -->  k$ = CHR$(13)
'                                                   k  = 13
'              (User pressed Enter on element 19)   e  = 19
'
'Note: This function is a good example of how to get more than one return
' value from a function.
'
'****************************************************************************

IF p$ = "" THEN                         'User pressed ESC
     k = 27
     e = 0
ELSEIF LEFT$(p$, 1) = "*" THEN          'User pressed a hotkey
     s = INSTR(p$, " ")
     k = VAL(MID$(p$, 2, s - 2))
     e = VAL(MID$(p$, s + 1))
ELSE                                    'User pressed Enter
     k = 13
     e = VAL(p$)
END IF

IF k > 0 THEN                           'Convert the keypress integer into a
     PickInfo$ = CHR$(k)                'real INKEY$ character value.
ELSE
     PickInfo$ = CHR$(0) + CHR$(-k)
END IF

END FUNCTION

