DEFINT A-Z

' $INCLUDE: 'PARM.INC'
' $INCLUDE: 'SETCURS.INC'
' $INCLUDE: 'TRUEFALS.INC'

DECLARE FUNCTION PickBox (msg$(), choice$(), parm())
DECLARE SUB InfoBox (msg$(), parm())
DECLARE SUB InfoBox2 (msg$, parm())
DECLARE FUNCTION YesNo (msg$(), yesword$, noword$, parm())
DECLARE FUNCTION YesNo2 (msg$, yesword$, noword$, parm())

'External procedures:

DECLARE SUB BoxCalc (t, l, b, r, tall, wide)
DECLARE FUNCTION GetKey$ (parm())
DECLARE SUB PopBox (t, l, b, r, wide, msg$(), parm())
DECLARE SUB RestScreen (f$)
DECLARE SUB SaveScreen (f$)
DECLARE SUB SetView (t, b, parm())
DECLARE FUNCTION TempName$ (p$)
DECLARE FUNCTION VPage (p)

SUB InfoBox (msg$(), parm())
'****************************************************************************
'Displays the text of the msg$() array in a pop-up box.  Basically, it is
' just a call to PickBox() with only one option of " Ok ".
'
'    parm(1) = top left row  0=Center
'    parm(2) = top left column  0=Center
'    parm(3) = box border type 1-4.  See SUB Panes() for numeric boxtypes.
'    parm(4) = message justification  <0=Left  0=Center  >0=Right
'
'See function PickBox() for more detailed information.
'
'****************************************************************************

REDIM choice$(1 TO 1)
choice$(1) = " Ok "

x = PickBox(msg$(), choice$(), parm())

ERASE choice$

END SUB

SUB InfoBox2 (msg$, parm())
'****************************************************************************
'Works just like InfoBox() but accepts a single text string rather than an
' array.
'
'    parm(1) = top left row  0=Center
'    parm(2) = top left column  0=Center
'    parm(3) = box border type 1-4.  See SUB Panes() for numeric boxtypes.
'    parm(4) = message justification  <0=Left  0=Center  >0=Right
'
'See functions InfoBox() and PickBox() for more detailed information.
'
'****************************************************************************

REDIM msg$(1 TO 1)
msg$(1) = msg$

REDIM choice$(1 TO 1)
choice$(1) = " Ok "

x = PickBox(msg$(), choice$(), parm())

ERASE msg$
ERASE choice$

END SUB

FUNCTION PickBox (msg$(), choice$(), parm())
'****************************************************************************
'Allows the user to pick from a horizontal light-bar menu within a pop-up
' message box.
'
'The informational text of the box is contained within the msg$() array.
'
'The choice$() array contains the items the user may pick from.  The function
' will return the element number of the item selected, or zero if the user
' presses ESC.
'
'    parm(1) = top left row  0=Center
'    parm(2) = top left column  0=Center
'    parm(3) = box border type 1-4.  See SUB Panes() for numeric boxtypes.
'    parm(4) = message justification  <0=Left  0=Center  >0=Right
'    parm(5) = initial selected choice
'
'If a combination of any of the above parameters causes a portion of the box
' to exceed the screen boundaries, a run-time error will occur.
'
'****************************************************************************

'                     *** Preliminary Calculations ***

minc = LBOUND(choice$)                  'Get info about the choice array.
maxc = UBOUND(choice$)

wide = 0: tall = 0                      'Find out how wide and tall to make
FOR x = LBOUND(msg$) TO UBOUND(msg$)    'the box.  Use either the longest
     l = LEN(msg$(x))                   'message or the combined width of all
     IF l > wide THEN wide = l          'the choices to measure the width.
     tall = tall + 1
NEXT x
tall = tall + 2                         'Allow for a blank line & choices.
l = 0
FOR x = minc TO maxc
     l = l + LEN(choice$(x)) + 1        'Allow for spaces between choices.
NEXT x
l = l - 1
IF l > wide THEN wide = l

row1 = parm(1)                          'Calculate where to place the box.
col1 = parm(2)
BoxCalc row1, col1, row2, col2, tall, wide

IF l = wide THEN                        'Calculate the column & row at which
     ccol = col1 + 1                    'the choices will begin.
ELSE
     ccol = col1 + 1 + ((wide - l) \ 2)
END IF
crow = row2 - 1

'                          *** Draw the Box ***

oldrow = CSRLIN                         'Save the current cursor location
oldcol = POS(0)
oldcursor = SetCursor(SCNONE)           'Turn the cursor off
savepage = VPage(0)                     'Allocate a video page to save the
IF savepage = 0 THEN                    'current screen on.  If unable to get
     savefile$ = TempName$("")          'one, we'll have to use the slower
     SaveScreen savefile$               'method of saving it to an actual
ELSE                                    'file.
     PCOPY 0, savepage
END IF

PopBox row1, col1, row2, col2, wide, msg$(), parm()

'                     *** Pick one of the choices ***

COLOR parm(FGWT), parm(BGWT)
sel = parm(5)

DO                                      'The main loop to pick a choice.

     IF sel < minc THEN sel = maxc
     IF sel > maxc THEN sel = minc

     LOCATE crow, ccol                  'Print the choices.
     FOR x = minc TO maxc
          IF x = sel THEN COLOR parm(FGWS), parm(BGWS)
          PRINT choice$(x);
          COLOR parm(FGWT), parm(BGWT)
          IF x < maxc THEN PRINT " ";
     NEXT x

     k$ = GetKey$(parm())                         'Get keyboard input:
     SELECT CASE ASC(LEFT$(k$, 1))
          CASE 27                                      'ESC
               PickBox = 0
               EXIT DO
          CASE 13                                      'Enter
               PickBox = sel
               EXIT DO
          CASE 0
               SELECT CASE ASC(RIGHT$(k$, 1))
                    CASE 75                            'Left Arrow
                         sel = sel - 1
                    CASE 77                            'Right Arrow
                         sel = sel + 1
                    CASE ELSE
                         'Ignore it
               END SELECT
          CASE ELSE
               'Ignore it
     END SELECT

LOOP

'                     *** Clean up after ourselves ***

IF savepage = 0 THEN                    'Restore the previous screen.
     RestScreen savefile$
     KILL savefile$
ELSE
     PCOPY savepage, 0
     x = VPage(savepage)
END IF
x = SetCursor(oldcursor)                'Restore the cursor.
COLOR parm(FGN), parm(BGN)              'Set colors to normal.
SetView -1, -1, parm()                  'Restore the previous viewport.
LOCATE oldrow, oldcol                   'Put the cursor back where it was.

END FUNCTION

FUNCTION YesNo (msg$(), yesword$, noword$, parm())
'****************************************************************************
'Works like PickBox() but returns TRUE if the yes option is selected or FALSE
' if the no option is selected or ESC is pressed.
'
'    parm(1) = top left row  0=Center
'    parm(2) = top left column  0=Center
'    parm(3) = box border type 1-4.  See SUB Panes() for numeric boxtypes.
'    parm(4) = message justification  <0=Left  0=Center  >0=Right
'    parm(5) = initial selected choice as TRUE or FALSE
'
'The function defaults to the words " Yes " and " No ".  If these are what
' you want, pass null strings for the optional words.  Common alternatives
' might be " Ok " and " Cancel ".
'
'See function PickBox() for more detailed information.
'
'****************************************************************************

REDIM choice$(-1 TO 0)                  'Notice how we trick PickBox into
IF LEN(yesword$) THEN                   'returning TRUE/FALSE values by
     choice$(-1) = yesword$             'creating an array with the proper
ELSE                                    'subscript values.
     choice$(-1) = " Yes "
END IF
IF LEN(noword$) THEN
     choice$(0) = noword$
ELSE
     choice$(0) = " No "
END IF

YesNo = PickBox(msg$(), choice$(), parm())

ERASE choice$

END FUNCTION

FUNCTION YesNo2 (msg$, yesword$, noword$, parm())
'****************************************************************************
'Works like YesNo() but accepts a single message string rather than an array.
'
'    parm(1) = top left row  0=Center
'    parm(2) = top left column  0=Center
'    parm(3) = box border type 1-4.  See SUB Panes() for numeric boxtypes.
'    parm(4) = message justification  <0=Left  0=Center  >0=Right
'    parm(5) = initial selected choice as TRUE or FALSE
'
'See functions YesNo() and PickBox() for more detailed information.
'
'****************************************************************************

REDIM msg$(1 TO 1)
msg$(1) = msg$

REDIM choice$(-1 TO 0)
IF LEN(yesword$) THEN
     choice$(-1) = yesword$
ELSE
     choice$(-1) = " Yes "
END IF
IF LEN(noword$) THEN
     choice$(0) = noword$
ELSE
     choice$(0) = " No "
END IF

YesNo2 = PickBox(msg$(), choice$(), parm())

ERASE msg$
ERASE choice$

END FUNCTION

