DEFINT A-Z

DECLARE FUNCTION ParseDie$ (die$)


'External procedures:

DECLARE FUNCTION Dice (n, d, a)
DECLARE FUNCTION Istr$ (i)

FUNCTION ParseDie$ (die$)
'****************************************************************************
'This function takes a string in "standard gaming notation" and returns a
' string of the stated dice roll's value.
'
'If the die$ string begins with an asterisk (*), ParseDie$() will interpret
' it as a constant (non-random value) and will return whatever follows the
' asterisk.
'
'If an illegal character is found in the string, the return value will begin
' with an at-sign (@) followed by the string position of the offending
' character.  The following characters are recognized by ParseDie$():
'
'                  *0123456789dD+- (spaces are ignored)
'
'Remember that the Dice() function accepts only integer arguments and returns
' and integer.  If the result of the die roll (or any of its parts) exceeds
' the limits of an integer variable (-32,768 to 32,767) a run-time error will
' occur.  If you need more, just rewrite these functions using long integers.
'
'    Examples: ParseDie$("3d6")   -->  "3" to "18"
'              ParseDie$("1d4+1") -->  "2" to "5"
'              ParseDie$("*15")   -->  "15"
'              ParseDie$("2d3.1") -->  "@4"  (Illegal character in 4th pos.)
'              ParseDie$("")      -->  "0"
'              ParseDie$("  ")    -->  "1" to "4"  (Defaults to 1d4)
'              ParseDie$("2d50000")    Crash!
'
'****************************************************************************

IF die$ = "" THEN                                 'Blank?
     ParseDie$ = "0"
     EXIT FUNCTION
END IF

x = INSTR(die$, "*")                              'Constant?
IF x > 0 THEN
     ParseDie$ = MID$(die$, x + 1)
     EXIT FUNCTION
END IF

n$ = ""        'Separate the string into the Number of rolls,
d$ = ""        'the number of sides on the Die,
a$ = ""        'and the amount to Add to each roll.

nda = 1        'Keep track of which one we're currently building.

FOR x = 1 TO LEN(die$)
     x$ = MID$(die$, x, 1)
     SELECT CASE ASC(x$)
          CASE 48 TO 57                           '0-9
               IF nda = 1 THEN n$ = n$ + x$
               IF nda = 2 THEN d$ = d$ + x$
               IF nda = 3 THEN a$ = a$ + x$
          CASE 68, 100                            'd/D
               nda = 2
          CASE 43, 45                             '+/-
               nda = 3
               a$ = x$
          CASE 32                                 'space
               'Ignore it
          CASE ELSE                               'Invalid character. Return
               ParseDie$ = "@" + Istr$(x)         'the location of the
               EXIT FUNCTION                      'offending character.
     END SELECT
NEXT x

IF LEN(n$) THEN n = VAL(n$) ELSE n = 1            'Default to 1d4+0
IF LEN(d$) THEN d = VAL(d$) ELSE d = 4
IF LEN(a$) THEN a = VAL(a$) ELSE a = 0

ParseDie$ = Istr$(Dice(n, d, a))                  'Get the value.

END FUNCTION

