'parm(1 to 10) - Usage varies with each function.  See the function source
' for the appropriate assignments.

'Min/Max settings:
' These constants are used to identify the lower and upper bounds of the 
' pre-defined parm() elements.  Use MAXPARM when creating your parm() array.

CONST MINPARM = 11       'Start of the pre-defined parm() elements.
CONST MAXPARM = 25       'Upper boundary of parm() array.

'Screen Colors:  
' (FG = Foreground, BG = Background)  
' All the library functions that accept parm() as an argument assume that the 
' screen colors are currently set as COLOR parm(FGN),parm(BGN) and will 
' restore this color setting upon exit.  If you remember this, your code and
' the library functions will get along just fine.

CONST MINCOLOR = 11      'First screen color element.
CONST MAXCOLOR = 23      'Last screen color element.

CONST FGN = 11           'Normal FG
CONST BGN = 12           'Normal BG
CONST FGH = 13           'Highlighted FG
CONST FGD = 14           'Dimmed FG
CONST FGS = 15           'Selected FG
CONST BGS = 16           'Selected BG
CONST FGDS = 17          'Dimmed Selected FG
CONST FGWB = 18          'Window Border FG
CONST BGWB = 19          'Window Border BG
CONST FGWT = 20          'Window Text FG
CONST BGWT = 21          'Window Text BG
CONST FGWS = 22          'Window Selected FG
CONST BGWS = 23          'Window Selected BG

'View Print settings:  
' These constants are used to reset the viewport after using the SCREEN 
' function.  To make sure the values remain current, use the SetView() sub 
' whenever changing the viewport instead of using VIEW PRINT directly.

CONST VPTOP = 24         'VIEW PRINT top setting
CONST VPBOT = 25         'VIEW PRINT bottom setting

