DEFINT A-Z

DECLARE FUNCTION PadC$ (orig$, newlen)
DECLARE FUNCTION PadL$ (orig$, newlen)
DECLARE FUNCTION PadR$ (orig$, newlen)
DECLARE FUNCTION PadX$ (orig$, newlen, side, char$)

FUNCTION PadC$ (orig$, newlen)

PadC$ = PadX$(orig$, newlen, 0, " ")

END FUNCTION

FUNCTION PadL$ (orig$, newlen)

PadL$ = PadX$(orig$, newlen, -1, " ")

END FUNCTION

FUNCTION PadR$ (orig$, newlen)

PadR$ = PadX$(orig$, newlen, 1, " ")

END FUNCTION

FUNCTION PadX$ (orig$, newlen, side, char$)
'****************************************************************************
'Pads a string with a specified character on the specified side(s) up to the
' new length.  A more flexible version of the other "Pad" functions (all of
' which are merely translated into calls to PadX$() with a space for the pad
' character!).
'
'The side argument is expressed like so:  <0 = Left
'                                          0 = Center
'                                         >0 = Right
'
'Examples: PadX$("Hello!",10,1," ") --> "Hello!    "
'          PadX$("$500",10,-1,"*")  --> "******$500"
'          PadX$("WOW",20,0,"!")    --> "!!!!!!!!WOW!!!!!!!!!"
'
'****************************************************************************

IF char$ = "" THEN                 'If char$ is null, default to a space.
     c$ = " "
ELSE
     c$ = char$
END IF

l = LEN(orig$)                     'Find length of original.

IF l = newlen THEN                 'If already equal to new length, return
     PadX$ = orig$                 'the original.
     EXIT FUNCTION
END IF

pad$ = STRING$(newlen, c$)         'Make a string completely of pad chars.

SELECT CASE side
     CASE IS < 0                                       'Pad Left
          PadX$ = RIGHT$(pad$ + orig$, newlen)
     CASE IS > 0                                       'Pad Right
          PadX$ = LEFT$(orig$ + pad$, newlen)
     CASE ELSE                                         'Pad Center (default)
          IF l > newlen THEN       'Original length > new length
               c$ = orig$
               DO WHILE l > newlen                'Trim one character off
                    l = l - 1                     'alternating sides until
                    IF l MOD 2 = 0 THEN           'the string equals the
                         c$ = RIGHT$(c$, l)       'new length.
                    ELSE
                         c$ = LEFT$(c$, l)
                    END IF
               LOOP
               PadX$ = c$
          ELSE                     'New length > original length
               diff = newlen - l
               l = diff \ 2
               r = diff - l
               PadX$ = STRING$(l, c$) + orig$ + STRING$(r, c$)
          END IF
END SELECT

END FUNCTION

