DEFINT A-Z

DECLARE FUNCTION Dmax# (a#, b#)
DECLARE FUNCTION Dmin# (a#, b#)
DECLARE FUNCTION Imax (a, b)
DECLARE FUNCTION Imin (a, b)
DECLARE FUNCTION Lmax& (a&, b&)
DECLARE FUNCTION Lmin& (a&, b&)
DECLARE FUNCTION Smax! (a!, b!)
DECLARE FUNCTION Smin! (a!, b!)

'****************************************************************************
'The various max() and min() functions simply return the larger or smaller of
' two numbers.  There is one set of functions for each of the numeric data
' types.
'
'While useful by themselves, they can be extremely handy when used in pairs:
'
'    biggest = Imax(a, Imax(b, c))
'
'    smallest! = Smin!(a!, Smin!(b!, c!))
'
'****************************************************************************

FUNCTION Dmax# (a#, b#)

IF a# > b# THEN
     Dmax# = a#
ELSE
     Dmax# = b#
END IF

END FUNCTION

FUNCTION Dmin# (a#, b#)

IF a# < b# THEN
     Dmin# = a#
ELSE
     Dmin# = b#
END IF

END FUNCTION

FUNCTION Imax (a, b)

IF a > b THEN
     Imax = a
ELSE
     Imax = b
END IF

END FUNCTION

FUNCTION Imin (a, b)

IF a < b THEN
     Imin = a
ELSE
     Imin = b
END IF

END FUNCTION

FUNCTION Lmax& (a&, b&)

IF a& > b& THEN
     Lmax& = a&
ELSE
     Lmax& = b&
END IF

END FUNCTION

FUNCTION Lmin& (a&, b&)

IF a& < b& THEN
     Lmin& = a&
ELSE
     Lmin& = b&
END IF

END FUNCTION

FUNCTION Smax! (a!, b!)

IF a! > b! THEN
     Smax! = a!
ELSE
     Smax! = b!
END IF

END FUNCTION

FUNCTION Smin! (a!, b!)

IF a! < b! THEN
     Smin! = a!
ELSE
     Smin! = b!
END IF

END FUNCTION

