DEFINT A-Z

' $INCLUDE: 'TRUEFALS.INC'

DECLARE FUNCTION MakeDir (directory$)


'External procedures:

DECLARE FUNCTION DirExist (directory$)


'Error handling:

DIM SHARED ecode

MDErr:
     ecode = ERR
     RESUME NEXT

FUNCTION MakeDir (directory$)
'****************************************************************************
'Creates a DOS directory.  Unlike the MKDIR command, MakeDir() can create a
' directory more than one level deep or on a different drive.
'
'The directory$ argument may be passed with or without a trailing backslash.
'
'Returns TRUE if successful, FALSE if unable to create the directory.  If
' unable to create the directory, MakeDir() DOES NOT clean up after itself by
' removing any partially created subdirectories.
'
'If creating a multi-level subdirectory, it is best to pass the whole
' pathname, including the drive letter.
'
'Examples:  MakeDir("GAMES")  Creates a subdirectory "GAMES" off the current
'                             directory.
'
'           MakeDir("C:\SCIENCE\DATA")  Creates the specified directory. If
'                                       the \SCIENCE directory doesn't exist,
'                                       it will get created too.  This would
'                                       crash the MKDIR command.
'
'Note: MUST be compiled with the /X switch due to the RESUME NEXT stuff.
'
'Caution: If using MakeDir() on a floppy drive, MAKE SURE that there is a
' diskette in the drive or your computer will hang.
'
'****************************************************************************

d$ = directory$                    'Use a temporary variable.

IF DirExist(d$) THEN               'If it already exists, return TRUE and
     MakeDir = TRUE                'take credit for creating it!  This works
     EXIT FUNCTION                 'for a null string too.
END IF

bs$ = "\"

IF RIGHT$(d$, 1) = bs$ THEN        'Remove the trailing backslash, if any.
     d$ = LEFT$(d$, LEN(d$) - 1)
END IF

FOR x = 1 TO LEN(d$)               'Go through the new path one subdirectory
     c$ = MID$(d$, x, 1)           'at a time until the whole thing exists.
     IF c$ = bs$ THEN
          IF NOT DirExist(subdir$) THEN
               GOSUB MakeOne
          END IF
     END IF
     subdir$ = subdir$ + c$
NEXT x

GOSUB MakeOne                      'This is the final one! (subdir$ = d$)

MakeDir = TRUE                     'Everything went Ok to get to this point.

EXIT FUNCTION                      'Avoid a RETURN WITHOUT GOSUB error!


MakeOne:

     ON ERROR GOTO MDErr           'We can never assume that the user of the
     MKDIR subdir$                 'program has a clue and didn't just type
     ON ERROR GOTO 0               'a bunch of garbage at the input prompt
     IF ecode THEN EXIT FUNCTION   'that might choke the MKDIR command.
     RETURN                        '(As a rule, you should edit user input
                                   'before doing anything important with it.)

END FUNCTION

