DEFINT A-Z

DECLARE FUNCTION Justify$ (orig$, side)

FUNCTION Justify$ (orig$, side)
'****************************************************************************
'Moves leading or trailing spaces to the appropriate side of the string,
' while retaining the original length of the string.
'
'The side argument can take one of the following forms:
'
'    <0  =  Left justify   (move leading spaces to the right side)
'     0  =  Center justify (spread spaces evenly on both sides)
'    >0  =  Right justify  (move trailing spaces to the left side)
'
'Feel free to create some constants so these values easier to remember.
'
'The function works by comparing the size of the original string to the size
' of the string after trimming the appropriate spaces.  These spaces are then
' tacked back on to the appropriate side.
'
'Examples:  Justify$("Some text    ", 0)  -->  "  Some text  "
'           Justify$("Some more    ", 1)  -->  "    Some more"
'           Justify$("   Even more!",-1)  -->  "Even more!   "
'
'****************************************************************************

l = LEN(orig$)                          'Get the original length.

SELECT CASE side
     CASE IS < 0                        'Left justify
          new$ = LTRIM$(orig$)
          n = l - LEN(new$)
          new$ = new$ + SPACE$(n)
     CASE IS > 0                        'Right justify
          new$ = RTRIM$(orig$)
          n = l - LEN(new$)
          new$ = SPACE$(n) + new$
     CASE ELSE                          'Center justify
          new$ = LTRIM$(RTRIM$(orig$))
          n = l - LEN(new$)
          FOR l = 1 TO n                     'Stick the spaces back onto
               IF l MOD 2 = 0 THEN           'alternating sides until we're
                    new$ = " " + new$        'back to the original length.
               ELSE
                    new$ = new$ + " "
               END IF
          NEXT l
END SELECT

Justify$ = new$                         'Return the justified string.

END FUNCTION

