DEFINT A-Z

' $INCLUDE: 'TRUEFALS.INC'

DECLARE FUNCTION IsNum (text$)

FUNCTION IsNum (text$)
'****************************************************************************
'Returns TRUE if the text contains only numeric data, FALSE otherwise.
'
'The function considers a lone minus sign (-) to be an operator, not numeric.
' The same goes for a lone decimal point.  Both characters ARE allowed if
' cohabitating with digits (would their mothers approve?).
'
'Examples:  IsNum("12")   --> TRUE      IsNum("ABC") --> FALSE
'           IsNum("-6")   --> TRUE      IsNum(" ")   --> FALSE
'           IsNum("1.3")  --> TRUE      IsNum("-")   --> FALSE
'           IsNum("")     --> FALSE     IsNum(".")   --> FALSE
'
'****************************************************************************

IsNum = FALSE                      'Assume the worst.

d$ = "."                           'For optimization.
m$ = "-"

t$ = LTRIM$(RTRIM$(text$))         'Trim any spaces from text$.

IF t$ = "" THEN EXIT FUNCTION      'Return FALSE if there's nothing left.

IF t$ = d$ OR t$ = m$ THEN EXIT FUNCTION          'No lone symbols!

'Check each character's ASCII code to make sure it is one of the following:
'A minus sign (45), a decimal (46), or a digit (48-57).

FOR x = 1 TO LEN(t$)
     a = ASC(MID$(t$, x, 1))
     IF (a < 45) OR (a > 57) OR (a = 47) THEN EXIT FUNCTION
NEXT x

'Make sure that there is not more than one minus sign and if there is one,
'that it is only in the first position.  Also make sure there is only one
'decimal point.

minus = INSTR(t$, m$)              'Find location of first occurrences.
dot = INSTR(t$, d$)

IF minus > 1 THEN EXIT FUNCTION    'Allowed only in first position!

minus = minus + 1                                 'Make sure there's only one
IF INSTR(minus, t$, m$) > 1 THEN EXIT FUNCTION    'of each.
dot = dot + 1
IF INSTR(dot, t$, d$) > 1 THEN EXIT FUNCTION

IsNum = TRUE                       'All tests must pass to reach this point.

END FUNCTION

