DEFINT A-Z

' $INCLUDE: 'PARM.INC'
' $INCLUDE: 'SETCURS.INC'
' $INCLUDE: 'TRUEFALS.INC'

DECLARE FUNCTION GetKey$ (parm())
DECLARE FUNCTION LastKey$ (k$)

'External functions:

DECLARE SUB RestScreen (f$)
DECLARE SUB SaveScreen (f$)
DECLARE SUB SetView (top, bot, parm())
DECLARE FUNCTION TempName$ (p$)
DECLARE FUNCTION VPage (p)

FUNCTION GetKey$ (parm()) STATIC
'****************************************************************************
'Used to control user input.  It includes a screensaver routine and a way to
' trap hotkeys with polling rather than ON KEY.  Use it where you would
' normally place an INKEY$ loop.
'
'Chances are, you will want to modify this function for each program that you
' write.  See below for information about how the screensaver works and how
' to add hotkey procedures.
'
'****************************************************************************

STATIC busy

idle! = TIMER

DO

     'If it has been 5 minutes since a keypress, do the screensaver routine:

     IF TIMER > (idle! + 300) THEN
          oldcursor = SetCursor(SCNONE)      'Turn the cursor off.
          savepage = VPage(0)                'Allocate a video page for a
          IF savepage = 0 THEN               'screen save.  If none are
               savefile$ = TempName$("")     'available, use the slower
               SaveScreen savefile$          'save to file method.
          ELSE
               PCOPY 0, savepage
          END IF
          VIEW PRINT                         'Clear any active viewport.
          COLOR 7, 0
          DO                                 'Show the time on the screen in
               CLS                           'random colors and locations
               row = INT(RND * 24) + 1       'until a key is pressed.
               col = INT(RND * 72) + 1
               c = INT(RND * 7) + 9
               LOCATE row, col
               COLOR c
               PRINT TIME$;
               SLEEP (2)
          LOOP WHILE INKEY$ = ""
          IF savepage = 0 THEN               'Restore the screen according to
               RestScreen savefile$          'how we saved it.
               KILL savefile$
          ELSE
               PCOPY savepage, 0
          END IF
          SetView -1, -1, parm()             'Restore the previous viewport.
          c = SetCursor(oldcursor)           'Restore the previous cursor.
          COLOR parm(FGN), parm(BGN)         'Set colors back to normal.
          idle! = TIMER                      'Reset the idle timer.
     END IF

     'Otherwise check the keyboard for activity:

     x$ = INKEY$

     'If a key was pressed, see if it was a hotkey before returning it:

     IF LEN(x$) AND NOT busy THEN            'Check for hotkeys
          SELECT CASE x$

               'Put your hotkey procedures here.  If one is called, be sure
               'to set busy to TRUE.  This prevents hotkey procedures from
               'being called from within other hotkey procedures.  Don't
               'forget to reset busy to FALSE when finished.
               '
               'Example:  SELECT CASE x$
               '              CASE CHR$(0) + CHR$(68)       'F10
               '                   busy = TRUE
               '                   MyHotKeySub  (Whatever your procedure is)
               '                   busy = FALSE
               '              CASE...

               CASE ELSE
                    'Not a hotkey.
          END SELECT
     END IF

LOOP UNTIL LEN(x$)

GetKey$ = x$                            'Return the value of the keypress.
x$ = LastKey$(x$)                       'Update LastKey$() with this value.

END FUNCTION

FUNCTION LastKey$ (k$) STATIC
'****************************************************************************
'When used in conjunction with GetKey$(), LastKey$() will return the value
' returned by the previous call to GetKey$().  One possible use would be to
' find out the key used to exit a previously called function (assuming that
' function used GetKey$() for all its input).
'
'To use the function, merely pass a null string as the argument.  This will
' return the stored value without changing it.  Should you wish to update
' LastKey$() with a value other than the one placed there by the last call to
' GetKey$(), just pass it a non-null string.
'****************************************************************************

STATIC last$

LastKey$ = last$                   'Retain previous value for return.

IF LEN(k$) THEN                    'If anything other than a null string is
     last$ = k$                    'passed, the value of LastKey$() will be
END IF                             'updated.

END FUNCTION

