DEFINT A-Z

DECLARE FUNCTION FileParts$ (filespec$, operation$)


'External procedures:

DECLARE FUNCTION Rinstr (start, search$, lookfor$)

FUNCTION FileParts$ (filespec$, operation$)
'****************************************************************************
'Returns a specified part of an extended filename or other filespec type
' string.
'
'The return value depends upon the value of the operation$ argument:
'
'Example: filespec$ = "C:\GAMES\SAVEGAME.001"
'         FileParts$(filespec$,"P")  -->  "C:\GAMES\"       (Path)
'         FileParts$(filespec$,"F")  -->  "SAVEGAME.001"    (Filename)
'         FileParts$(filespec$,"E")  -->  "001"             (Extension)
'         FileParts$(filespec$,"N")  -->  "SAVEGAME"        (fileName)
'         FileParts$(filespec$,"D")  -->  "C:"              (Drive)
'
'         filespec$ = "HOMEWORK.TXT"
'         FileParts$(filespec$,"P")  -->  ""   Returns null if the requested
'         FileParts$(filespec$,"D")  -->  ""   info is not part of filespec$
'
'Paths are returned with a trailing backslash.  Drive letters are returned
' with a trailing colon.  Extensions are returned without a leading period.
'
'Quirks:  FileParts$() assumes that all pathnames end in a backslash.  If you
' pass the function one that does not, it will think that it is a filename:
'
' Example: "C:\GAMES" will be interpreted as a file called "GAMES" in the
'           root directory of C:.  "C:\GAMES\" would be Ok.
'
'Note: The letter "X" is accepted as well as "E" to get the extension.
'
'****************************************************************************

fspec$ = LTRIM$(RTRIM$(filespec$))      'Trim any spaces off filespec$

IF fspec$ = "" THEN                     'If the filespec is a null string,
     FileParts$ = ""                    'return a null string.
     EXIT FUNCTION
END IF

bs$ = "\"                               'For optimization.
part$ = ""                              'Initialize to null.

dot = INSTR(fspec$, ".")                'Find a dot, if any.
colon = INSTR(fspec$, ":")              'Find a colon, if any.
lastslash = Rinstr(0, fspec$, bs$)      'Find the last backslash, if any.

SELECT CASE UCASE$(LEFT$(operation$, 1))
     CASE "F"                                                    'Filename
          IF lastslash THEN             'Find the left boundary   (w/ ext.)
               l = lastslash + 1
          ELSEIF colon THEN
               l = colon + 1
          ELSE
               l = 1          'It must be a filename only.
          END IF
          part$ = MID$(fspec$, l)
     CASE "N"                                                    'fileName
          IF lastslash THEN             'Find the left boundary   (w/o ext.)
               l = lastslash + 1
          ELSEIF colon THEN
               l = colon + 1
          ELSE
               l = 1
          END IF
          IF dot THEN                   'Find the right boundary
               r = dot - 1
               part$ = MID$(fspec$, l, (dot - l))
          ELSE
               part$ = MID$(fspec$, l)
          END IF
     CASE "E", "X"                                               'EXtension
          IF dot THEN
               part$ = MID$(fspec$, (dot + 1))
          END IF
     CASE "P"                                                    'Path
          IF lastslash THEN                      'Regular pathname
               part$ = LEFT$(fspec$, lastslash)
          ELSEIF colon THEN                      'Drive letter only
               part$ = LEFT$(fspec$, colon) + bs$
          END IF
     CASE "D"                                                    'Drive
          IF colon THEN
               part$ = LEFT$(fspec$, colon)
          END IF
     CASE ELSE                                                   'What???
          part$ = ""
END SELECT

FileParts$ = part$                      'Return the requested information.

END FUNCTION

