DEFINT A-Z

DECLARE FUNCTION DirAttr$ (a)
DECLARE FUNCTION DirDate$ (d&)
DECLARE FUNCTION DirTime$ (t)

FUNCTION DirAttr$ (a)
'****************************************************************************
'This function takes as its argument the integer received from the Attribute
' field of a DirType variable (See DIR.INC).  It then returns a 5-character
' string with letters representing the file or directory's attributes.
'
'If all the attributes were set, the function would return "DRHSA", where:
'
'    D = Directory
'    R = Read Only
'    H = Hidden
'    S = System
'    A = Archive
'
'If one or more attributes are missing, their location in the string will be
' blank.
'
'Example: "    A" = A file with only an archive attribute.
'         " RHS " = A read only, hidden, system file (such as IO.SYS).
'
'This code is also useful to see how you can interpret the values on your
' own.  And you thought you would never find a use for the bitwise AND!
'
'****************************************************************************

s$ = "     "

IF (a AND 16) THEN MID$(s$, 1, 1) = "D"
IF (a AND 1) THEN MID$(s$, 2, 1) = "R"
IF (a AND 2) THEN MID$(s$, 3, 1) = "H"
IF (a AND 4) THEN MID$(s$, 4, 1) = "S"
IF (a AND 32) THEN MID$(s$, 5, 1) = "A"

DirAttr$ = s$

END FUNCTION

FUNCTION DirDate$ (d&)
'****************************************************************************
'This function converts the long integer value of a DirType.EntryDate into a
' string in the form of MM/DD/YY.
'****************************************************************************

x$ = LTRIM$(STR$(d&))

y$ = MID$(x$, 3, 2)
m$ = MID$(x$, 5, 2)
d$ = MID$(x$, 7, 2)

x$ = "/"

DirDate2$ = m$ + x$ + d$ + x$ + y$

END FUNCTION

FUNCTION DirTime$ (t)
'****************************************************************************
'This function takes the integer value of a DirType.EntryTime field and
' converts it to a string in the form of HH:MMa.
'****************************************************************************

z$ = "00"
am$ = "a"
pm$ = "p"

h = t \ 100                             'Convert hours first...

SELECT CASE h                           'Returned in 24 hour format:
	CASE 0                   'Midnight
		h = 12
		ampm$ = am$
	CASE IS < 12             'Morning
		ampm$ = am$
	CASE 12                  'Noon
		ampm$ = pm$
	CASE ELSE                'Afternoon
		h = h - 12
		ampm$ = pm$
END SELECT

h$ = RIGHT$(z$ + LTRIM$(STR$(h)), 2)
m$ = RIGHT$(z$ + LTRIM$(STR$(t)), 2)    'Minutes are easy...

DirTime2$ = h$ + ":" + m$ + ampm$

END FUNCTION

