DEFINT A-Z

' $INCLUDE: 'TRUEFALS.INC'
' $INCLUDE: 'DIR.INC'

DECLARE FUNCTION DirExist (dirname$)

FUNCTION DirExist (dirname$)
'****************************************************************************
'The function will return TRUE if the directory in question exists, FALSE
' otherwise.
'
'The dirname$ argument may be passed with or without a trailing backslash.
'
'Note: A null string passed to the function will be interpreted as the
' current directory and the function will return TRUE.
'
'Caution:  Attempting to use this function on an empty diskette drive will
' hang your computer.  Make sure there is a disk inserted first.
'
'See function MakeDir() for an example of use.
'
'****************************************************************************

IF LEN(dirname$) = 0 THEN               'Assume a null string is referring to
     DirExist = TRUE                    'the current directory and return
END IF                                  'TRUE.

DIM DirInfo AS DirType

bs$ = "\"

d$ = dirname$                           'Don't alter the original.

IF RIGHT$(d$, 1) <> bs$ THEN            'Add a trailing backslash if needed.
     d$ = d$ + bs$
END IF

d$ = d$ + "*.*"

f$ = Dir$(d$, DirInfo)                  'See if there is anything there...

IF LEN(f$) AND DirInfo.ErrorCode = 0 THEN DirExist = TRUE

END FUNCTION

