DEFINT A-Z

' $INCLUDE: 'QB.BI'
' $INCLUDE: 'DIR.INC'

'(Function declaration is in the include file)

DECLARE FUNCTION DTABit% (BitNumber%)   'Used only by the Dir$() function.

DIM SHARED DTAOff%

FUNCTION Dir$ (file$, DirInfo AS DirType)
'****************************************************************************
'Credit for this function must go to Fairchild Computer Services.  The code
' has been altered from the original to suit my purposes.  The original is
' available on CompuServe as "DIR.ZIP", and comes with some other good stuff.
' It is one of the most useful things I have ever downloaded.  Thank you, FCS
' for sharing your knowledge with the rest of us!
'
'I changed the original function by making the DirType variable a passed
' parameter rather than a COMMON SHARED variable, and altering the format of
' the EntryTime & EntryDate values.
'
'The file$ parameter may be passed as an individual filename, or a filespec
' that includes wildcards and/or extended pathnames - just as if you were
' typing "DIR" at the DOS prompt.
'
'The DirType variable will be filled with other information about the file
' found (if any).  See DIR.INC for the type declaration.
'
'If any files match the wildcard, the function will return the filename of
' the first matching file.  If a single filename was passed, you'll just get
' the same name back and will then know that the file exists.  The DirType
' argument will contain the file's other information.
'
'If no files match the wildcard or the single filename does not exist, Dir$()
' will return a null string ("") and the DirType variable will not be updated
' except with an ErrorCode.
'
'To get further matches to a wildcard, continue to call Dir$() with a null
' file$ argument.  Keep doing this until a null string is returned.  This
' will indicate that no further files match the wildcard.
'
'Example: ' $INCLUDE: 'DIR.INC'
'         DIM DirInfo AS DirType
'         f$ = Dir$("*.*", DirInfo)
'         IF f$ = "" THEN
'              PRINT "No files found"
'         ELSE
'              PRINT "These files were found:"
'              DO
'                   PRINT f$
'                   f$ = Dir$("", DirInfo)
'              LOOP UNTIL f$ = ""
'         END IF
'
'If there is a problem (such as an invalid pathname) Dir$() will return the
' string "***ERROR***" and the DirType.ErrorCode will contain a value.
'
'Caution: Don't try to run Dir$() against an empty diskette drive.  You'll
' hang the computer.  Make sure there's a diskette in there first!
'
'See the functions FileExist(), FileSize&() and DirExist() for more examples.
'
'See the functions in DIRSTUFF.BAS for examples of how to interpret the
' values in the DirType variable.
'
'****************************************************************************

DIM InRegsX AS RegTypeX, OutRegsX AS RegTypeX

null$ = ""

InRegsX.ax = &H2F00                          'For extensive comments on the
CALL INTERRUPTX(&H21, InRegsX, OutRegsX)     'workings of this function,
DTASeg% = OutRegsX.es                        'download the original DIR.ZIP
DTAOff% = OutRegsX.bx                        'from CompuServe.
t$ = null$
IF file$ <> null$ THEN             'Find first...
	svfile$ = file$ + CHR$(0)
	InRegsX.ax = &H4E00
	InRegsX.cx = &HFFFF
	InRegsX.ds = VARSEG(svfile$)
	InRegsX.dx = SADD(svfile$)
	GOSUB DoInterrupt
ELSE                               'Find next...
	InRegsX.ax = &H4F00
	GOSUB DoInterrupt
END IF
DEF SEG = DTASeg%
c% = 30
t$ = null$
DO
	t$ = t$ + CHR$(DTABit%(c%))
	c% = c% + 1
LOOP UNTIL DTABit%(c%) = 0

DirInfo.EntryName = LEFT$(t$ + SPACE$(12), 12)

l& = DTABit%(22) + DTABit%(23) * 256&             'Convert Time to HHMM%
c% = (l& \ 2048) * 100                  'Hour 0-23
c% = c% + ((l& \ 32) AND 63)            'Minutes
DirInfo.EntryTime = c%

l& = DTABit%(24) + DTABit%(25) * 256&             'Convert Date to YYYYMMDD&
x& = ((l& \ 512) + 1980) * 10000&       'Year
x& = x& + ((l& \ 32) AND 15) * 100&     'Month
x& = x& + (l& AND 31)                   'Day
DirInfo.EntryDate = x&

DirInfo.EntrySize = DTABit%(26) + DTABit%(27) * 256& + DTABit%(28) * 65536 + DTABit%(29) * 16777216

DirInfo.Attribute = DTABit%(21)

DirInfo.DirectoryFlag = DirInfo.Attribute AND 16

DEF SEG

GOTO ExitDir


DoInterrupt:
    
	CALL INTERRUPTX(&H21, InRegsX, OutRegsX)
	ErrorFlag% = OutRegsX.flags AND 1
	DirInfo.ErrorCode = OutRegsX.ax
	IF ErrorFlag% THEN
		IF DirInfo.ErrorCode <> 18 THEN     '18=No more files.  That is Ok.
			t$ = "***ERROR***"
		END IF
		GOTO ExitDir
	END IF
	RETURN


ExitDir:
    
	Dir$ = t$


END FUNCTION

FUNCTION DTABit% (BitNumber%)

  DTABit% = PEEK(DTAOff% + BitNumber%)

END FUNCTION

