DEFINT A-Z

DECLARE FUNCTION CountIn (search$, lookfor$)

FUNCTION CountIn (search$, lookfor$)
'****************************************************************************
'Returns the number of times that a substring is found within a string.
'****************************************************************************

count = 0

IF search$ = "" OR lookfor$ = "" THEN             'Exit if searching in or
     CountIn = count                              'looking for a null string.
     EXIT FUNCTION
END IF

x = INSTR(search$, lookfor$)                      'Find the first occurrence.

DO WHILE x > 0                                    'Go through the string,
     count = count + 1                            'incrementing count and
     last = x                                     'increasing the starting
     x = INSTR((last + 1), search$, lookfor$)     'position each time the
LOOP                                              'substring is found.

CountIn = count                                   'Return the count.

END FUNCTION

