DEFINT A-Z

DECLARE FUNCTION Capitalize$ (orig$)

FUNCTION Capitalize$ (orig$)
'****************************************************************************
'Capitalizes the first letter of each word in a string after first converting
' the whole thing to lower case.
'****************************************************************************

IF orig$ = "" THEN                      'If the original is a null string,
     Capitalize$ = ""                   'return a null string as it can not
     EXIT FUNCTION                      'be capitalized!
END IF

new$ = LCASE$(orig$)                    'Don't alter the original in case the
                                        'calling program still needs it!
                                        'And make it all lower case while
                                        'we're at it.

MID$(new$, 1, 1) = UCASE$(MID$(new$, 1, 1))  'Capitalize the first character.

FOR x = 1 TO (LEN(new$) - 1)            'Go through the string, capitalizing
                                        'anything that follows a space.
     IF MID$(new$, x, 1) = " " THEN
          MID$(new$, (x + 1), 1) = UCASE$(MID$(new$, (x + 1), 1))
     END IF

NEXT x

Capitalize$ = new$                      'Return the capitalized string.

END FUNCTION

