'****************************************************************************
'********************               BMAKE                ********************
'********************            Version 1.0             ********************
'********************                by                  ********************
'********************         Raymond W. Marron          ********************
'********************      HOMONCULOUS PROGRAMMING       ********************
'********************             Mesa, AZ               ********************
'****************************************************************************

'Be sure to load the HOMONLIB.QLB upon startup: QB /L HOMONLIB.QLB BMAKE.BAS

'Compile as follows: BC BMAKE /O/S/T  (or from the RUN menu)

'*************************** Constants/Includes *****************************

DEFINT A-Z

' $DYNAMIC
' $INCLUDE: 'DIR.INC'
' $INCLUDE: 'TRUEFALS.INC'

'*************************** LIB/QLB Procedures *****************************

'This is a special function to return an errorlevel code to DOS when exiting
'the program.  DO NOT USE THIS COMMAND IN THE INTERPRETER!
'Unremark this line and the one in SUB ErrExit ONLY when ready to compile.

'DECLARE SUB EndLevel ALIAS "_exit" (BYVAL Level%)

'**************************** Local Procedures ******************************

DECLARE SUB ErrExit ()
DECLARE SUB MakeBatch ()
DECLARE SUB ParseCmd ()
DECLARE SUB ReadFile ()
DECLARE SUB Startup ()

'************************ Define Global Variables ***************************

DIM SHARED DirInfo AS DirType
DIM SHARED report
DIM SHARED batch$
DIM SHARED errfile$
DIM SHARED maxfiles
DIM SHARED maxcmds
DIM SHARED makefile$
DIM SHARED compiler$
DIM SHARED options$
DIM SHARED nf                           'Number of files in .BMK file
DIM SHARED nc                           'Number of commands in .BMK file

'******************** Assign Values to Misc Variables ***********************

batch$ = "_~BMAKE_.BAT"
errfile$ = "_~BMAKE_.ERR"
compiler$ = "BC"
maxfiles = 100
maxcmds = 10

'***************************** Launch Program *******************************

ParseCmd                           'Translate the command line to know how
							'large the arrays need to be dimensioned.
DIM SHARED object$(1 TO maxfiles)
DIM SHARED source$(1 TO maxfiles)
DIM SHARED option$(1 TO maxfiles)
DIM SHARED cmd$(1 TO maxcmds)

Startup                            'Find the makefile.
ReadFile                           'Read/parse it's contents.
MakeBatch                          'Transfer the comparisons to a batch file.

ERASE object$                      'Free up the memory used by the arrays.
ERASE source$
ERASE option$
ERASE cmd$

f$ = Dir$(batch$, DirInfo)         'Run the batch file that contains all of
IF LEN(f$) THEN                    'the commands (if it exists).
	OPEN errfile$ FOR OUTPUT AS #1
	PRINT #1, "You may safely delete this file if found."
	CLOSE #1
	SHELL batch$
	KILL batch$
	f$ = Dir$(errfile$, DirInfo)  'If the errorfile was deleted, it means
	IF LEN(f$) THEN               'the batch file ended in error.
		KILL errfile$
	ELSE
		PRINT
		PRINT "BMAKE execution stopped."
		ErrExit
	END IF
END IF

END

'************************* Error Handling Routines **************************


'***************************** Data Statements ******************************


'****************************************************************************
'********************     End of Module Level Code       ********************
'****************************************************************************

SUB ErrExit
    
	PRINT
	BEEP
'     EndLevel (1)       'DON'T RUN THIS LINE IN THE INTERPRETER!!!
	SYSTEM

END SUB

SUB MakeBatch

berr$ = "@if errorlevel 1 goto BErr"

OPEN batch$ FOR OUTPUT AS #1

IF report THEN
	PRINT #1, "@copy "; batch$; " PRN"
END IF

FOR x = 1 TO nf

	f$ = Dir$(source$(x), DirInfo)     'Get date/time of source file
	IF f$ = "" THEN
		CLOSE #1
		KILL batch$
		PRINT
		PRINT "ERROR: File not found - " + source$(x)
		ErrExit
	END IF
	sd& = DirInfo.EntryDate
	st = DirInfo.EntryTime

	f$ = Dir$(object$(x), DirInfo)     'Get date/time of object file
	IF LEN(f$) = 0 THEN
		od& = 0
		ot = 0
	ELSE
		od& = DirInfo.EntryDate
		ot = DirInfo.EntryTime
	END IF

	IF report THEN
		LPRINT
		LPRINT source$(x); TAB(15); sd&; TAB(25); st
		LPRINT object$(x); TAB(15); od&; TAB(25); ot
	END IF

	IF od& > sd& THEN GOTO NextFile                   'Compare dates
	IF od& = sd& AND ot > st THEN GOTO NextFile       'Compare times

	o$ = options$                                'Global compiler options
	IF LEN(option$(x)) > 0 THEN
		x$ = MID$(option$(x), 2)
		IF LEFT$(option$(x), 1) = "&" THEN      'Additional options? (&)
			o$ = o$ + x$
		ELSE                                    'Replacement options (!)
			o$ = x$
		END IF
	END IF

	c$ = " " + source$(x) + " " + o$ + ", " + object$(x) + ";"

	PRINT #1, compiler$; c$
	PRINT #1, berr$

	IF report THEN
		LPRINT SPACE$(31); "Compiled."
	END IF

NextFile:
	
NEXT x

IF report THEN
	LPRINT
	LPRINT
END IF

FOR x = 1 TO nc                    'Add the COMMANDs to the batch file
	PRINT #1, cmd$(x)
	PRINT #1, berr$
NEXT x

PRINT #1, "@goto End"
PRINT #1, ":BErr"
PRINT #1, "@echo off"
PRINT #1, "del "; errfile$
PRINT #1, ":End"

CLOSE #1

END SUB

SUB ParseCmd

c$ = COMMAND$

x = INSTR(c$, "/")

IF x = 0 THEN                           'No other options specified?
	makefile$ = c$
	EXIT SUB
END IF

makefile$ = RTRIM$(LEFT$(c$, x - 1))    'Extract makefile name and trim it
c$ = MID$(c$, x)                        'off the rest.

DO

	SELECT CASE LEFT$(c$, 3)
		CASE "/F:"                    'Specify maxfiles
			GOSUB SplitIt
			IF v > 0 THEN
				maxfiles = v
			ELSE
				x$ = "/F:"
				GOTO BadValue
			END IF
		CASE "/C:"                    'Specify maxcmds
			GOSUB SplitIt
			IF v > 0 THEN
				maxcmds = v
			ELSE
				x$ = "/C:"
				GOTO BadValue
			END IF
		CASE "/PR"                    'Print Report (undocumented)
			c$ = RIGHT$(c$, LEN(c$) - 3)
			report = TRUE
		CASE ELSE                     'What???
			PRINT
			PRINT "ERROR: Unrecognized command line option(s): "; c$
			ErrExit
	END SELECT

LOOP UNTIL LEN(c$) = 0

EXIT SUB


SplitIt:
	x = INSTR(2, c$, "/")
	IF x = 0 THEN
		v = VAL(MID$(c$, 4))    'Only want the stuff after the colon.
		c$ = ""
	ELSE
		v = VAL(MID$(RTRIM$(LEFT$(c$, x - 1)), 4))
		c$ = MID$(c$, x)
	END IF
	RETURN


BadValue:
	PRINT
	PRINT "ERROR: Invalid value for "; x$; ";v"
	ErrExit

END SUB

SUB ReadFile

bas$ = ".BAS"
obj$ = ".OBJ"

OPEN makefile$ FOR INPUT AS #1

DO WHILE NOT EOF(1)

	LINE INPUT #1, l$
    
	l$ = LTRIM$(RTRIM$(l$))                      'Make two copies of the
	o$ = l$                                      'line, one case-sensitive
	l$ = UCASE$(l$)                              'and one that's not.

	IF l$ = "" THEN GOTO NextLine                'Skip blank lines
	IF LEFT$(l$, 1) = "'" THEN GOTO NextLine     'Skip commented-out lines

	x = INSTR(l$, "'")                           'Remove in-line comments.
	IF x > 0 THEN
		x = x - 1
		l$ = RTRIM$(LEFT$(l$, x))
		o$ = RTRIM$(LEFT$(o$, x))
	END IF

	colon = INSTR(l$, ":")                       'Find a colon if any
	pipe = INSTR(l$, "|")                        'Find a pipe if any

	IF pipe > 0 THEN                             'Object/Source comparison?
	    
		nf = nf + 1                             'Too many?
		IF nf > maxfiles THEN
			PRINT
			PRINT "ERROR: Maximum object-source comparisons exceeded at"; nf
			PRINT "       Increase the /F: command line parameter."
			ErrExit
		END IF

		object$(nf) = RTRIM$(LEFT$(l$, pipe - 1))   'Separate object
		source$(nf) = LTRIM$(MID$(l$, pipe + 1))    'from source
	    
		work$ = LTRIM$(MID$(o$, pipe + 1))                'Use original
		x = INSTR(work$, "&")                             'string to
		IF x = 0 THEN                                     'separate other
			x = INSTR(work$, "!")                        'options (if any)
		END IF                                            'from source
		IF x > 0 THEN
			option$(nf) = LTRIM$(MID$(work$, x))
			source$(nf) = RTRIM$(LEFT$(source$(nf), x - 1))
		END IF
  
		IF INSTR(object$(nf), ".") = 0 THEN               'Add the
			object$(nf) = object$(nf) + obj$             'proper
		END IF                                            'extensions
		IF INSTR(source$(nf), ".") = 0 THEN               'if needed
			source$(nf) = source$(nf) + bas$
		END IF
		
		GOTO NextLine

	ELSEIF colon > 0 THEN                        'BMAKE keyword?
	    
		lv$ = LTRIM$(MID$(o$, colon + 1))       'Case-sensitive!
		SELECT CASE LEFT$(l$, 4)
			CASE "COMP"                                  'Alternate
				compiler$ = UCASE$(lv$)                 'compiler listed
				GOTO NextLine
			CASE "OPTI"                                  'Compiler options
				options$ = lv$
				GOTO NextLine
			CASE "COMM"                                  'Command
				nc = nc + 1
				IF nc > maxcmds THEN
					PRINT
					PRINT "ERROR: Maximum COMMAND: statements exceeded at"; nc
					PRINT "       Increase the /C: command line parameter."
					ErrExit
				END IF
				cmd$(nc) = lv$
				GOTO NextLine
			CASE ELSE                                    '???
				'See below
		END SELECT
    
	END IF

	PRINT
	PRINT "ERROR: Unrecognized syntax in make file:"
	PRINT "       "; o$
	ErrExit

NextLine:
LOOP

CLOSE #1

END SUB

SUB Startup

q$ = CHR$(34)

IF makefile$ = "" THEN
	PRINT
	PRINT "BMAKE 1.0 (c) 1995 Raymond W. Marron - HOMONCULOUS PROGRAMMING"
	PRINT "ERROR: Makefile not specified."
	ErrExit
END IF

IF INSTR(makefile$, ".") < 1 THEN       'Add the default extension if not
	makefile$ = makefile$ + ".BMK"     'supplied.
END IF

f$ = Dir$(makefile$, DirInfo)

IF f$ = "" OR f$ = "***ERROR***" THEN
	PRINT
	PRINT "ERROR: Makefile " + q$ + makefile$ + q$ + " not found."
	ErrExit
END IF

END SUB

