CLS
PRINT "               TEXT COLUMN INTERCHANGE PROGRAM"
PRINT "                           COLI.BAS"
PRINT "                COPYRIGHT (C) 1995 CHUCK BERNT"
PRINT "                      ALL RIGHTS RESERVED"
PRINT
PRINT
print
print "  This program changes columns in a text file.  It can total"
print "  (and average) any numeric column or calculate any column"
print "  that can be expressed as a QBASIC expression of the other columns."
print "  The expression may contain any QBASIC arithmetic or logical"
print "  operator or function.  Text may also be inserted.  The columns"
print "  can be defined (delimited) by white spaces, spaces, tabs, commas "
print "  or any valid ASCII character or series of characters.  This"
print "  program is written in QBASIC and will only work on machines"
print "  that have QBASIC (usually DOS versions later than 5.0)."
PRINT
PRINT
INPUT "Please type enter to continue ...", XDUMMY$
CLS
PRINT
PRINT "    When the program asks 'OUTPUT COLUMN X =' type in the input"
PRINT "    column number you would like in that output column & ENTER."
PRINT "**FOR EXAMPLE: 3 will place input column 3 in the output column."
PRINT "                                 OR"
PRINT "    Type any QBASIC expression using CX to represent input"
PRINT "    column X in the expression."
PRINT "**FOR EXAMPLE: (C1+C2)/2 will place the average of input"
print "               columns one and two in that output column."
PRINT "                                 OR"
PRINT "    Type any text starting with T.  This text will appear in"
print "    every line in that output column (without the leading T)."
print "    you may add trailing spaces."
PRINT "**FOR EXAMPLE: TABC    will place ABC    in every line in that"
print "               output column."
PRINT
PRINT "  TO END INPUT JUST ENTER A BLANK LINE."
APPEN$ = "\COLS\TXTTMP.BAS"
OPEN APPEN$ FOR APPEND AS #1
CAPT$ = "T"
SMALLT$ = "t"
CAPC$ = "C"
SMALLC$ = "c"
QUOTE$ = CHR$(34)

PRINT #1, "GENERATEOUTPUTCOLS:"

FOR I = 1 TO 200
I$ = LTRIM$(STR$(I))
REENTER:
PRINT "OUTPUT COLUMN "; I; " = ";
LINE INPUT INPUTLINE$
IF INPUTLINE$ = "" THEN GOTO CLOSING
INCAPT = INSTR(1, INPUTLINE$, CAPT$)
INSMALLT = INSTR(1, INPUTLINE$, SMALLT$)
IF (INCAPT = 1) OR (INSMALLT = 1) THEN GOTO INSERTTEXT
INCAPC = INSTR(1, INPUTLINE$, CAPC$)
INSMALLC = INSTR(1, INPUTLINE$, SMALLC$)
IF (INCAPC <> 0) OR (INSMALLC <> 0) THEN GOTO INSERTEXPRESSION
IF (VAL(INPUTLINE$) < 1) OR (VAL(INPUTLINE$) > 200) THEN GOTO OUTOFRANGE
PRINT #1, "OC$("; I$; ") = "; "C$("; INPUTLINE$; ")"
REM PRINT "OC$("; I$; ") = "; "C$("; INPUTLINE$; ")"
GETNEXTCOLUMN:
NEXT I


INSERTTEXT:
MID$(INPUTLINE$, 1, 1) = QUOTE$
PRINT #1, "OC$("; I$; ") = "; INPUTLINE$; QUOTE$
REM PRINT "OC$("; I$; ") = "; INPUTLINE$; QUOTE$
GOTO GETNEXTCOLUMN

INSERTEXPRESSION:
REM PRINT "INSERT EXPRESSION"

START = 1
CAPINPUTLINE$ = UCASE$(INPUTLINE$)

PARSE:
CPOSITION = INSTR(START, CAPINPUTLINE$, CAPC$)
IF CPOSITION = 0 THEN GOTO EQUATION
COLNUMBERPOS = CPOSITION + 1
COLSTRING$ = MID$(CAPINPUTLINE$, COLNUMBERPOS, 3)
COLNUMBER = VAL(COLSTRING$)
COLNUMBER$ = LTRIM$(STR$(COLNUMBER))
START = COLNUMBERPOS + 2
PRINT #1, "C"; COLNUMBER$; " = "; "VAL(C$("; COLNUMBER$; "))"
REM PRINT "C"; COLNUMBER$; " = "; "VAL(C$("; COLNUMBER$; "))"
GOTO PARSE

EQUATION:
PRINT #1, "OC$("; I$; ") = LTRIM$(STR$("; INPUTLINE$; "))"
REM PRINT "OC$("; I$; ") = LTRIM$(STR$("; INPUTLINE$; "))"
GOTO GETNEXTCOLUMN

OUTOFRANGE:
PRINT "  YOUR INPUT WAS "; INPUTLINE$; " AND SHOULD HAVE BEEN A NUMBER"
PRINT "  BETWEEN 1 AND 200 INCLUSIVE, THE LETTER T FOLLOWED BY TEXT OR"
PRINT "  AN EXPRESSION CONTAINING THE LETTER C (YOU CAN JUST ADD THE"
PRINT "  LETTER C TO YOUR PRESENT EXPRESSION SINCE C = 0)."
PRINT "  PLEASE REENTER THIS COLUMN."
GOTO REENTER




CLOSING:
I = I - 1
PRINT #1, "LASTCOL = "; I
REM PRINT "LASTCOL = "; I
PRINT #1, "RETURN"
REM PRINT "CLOSING TXTTMP"
CLOSE
REM SYSTEM
CHAIN "\COLS\TXTTMP"

