/*****************************************************************************
   MODULE: rstr.c
  PURPOSE: recio essential string functions
COPYRIGHT: (C) 1994-1995, William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 2.13
  RELEASE: September 4, 1995
*****************************************************************************/

#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "recio.h"

/****************************************************************************/
char *                       /* return trimmed string                       */
    scntrimbegs(             /* trim beginning of string                    */
        char  *str,          /* string to trim                              */
        int    ch,           /* character to match                          */
        size_t num)          /* maximum number of characters to trim        */
/****************************************************************************/
{
    char *sp;                /* string pointer */
    size_t i=0;              /* counter */

    if (str && *str && ch && num) {
        sp = str;

        /* increment through string while match is true */
        /* match any white space if ch is space */
        while ((ch == ' ') ? (isspace(*sp)) : (*sp == ch)) {
            sp++;
            i++;
            if (i==num) break;
        }

        if (sp != str) memmove(str, sp, strlen(sp)+1);
    }
    return str;
}

/****************************************************************************/
char *                       /* return trimmed string                       */
    scntrimends(             /* trim end of string                          */
        char *str,           /* string to trim                              */
        int    ch,           /* character to match                          */
        size_t num)          /* maximum number of characters to trim        */
/****************************************************************************/
{
    char *sp;                /* string pointer */
    size_t i=0;              /* counter */

    if (str && *str && ch && num) {
        /* point sp at last character in string */
        sp = str + strlen(str) - 1;

        /* decrement through string while match is true */
        /* match any white space if ch is space */
        while ((ch == ' ') ? (isspace(*sp)) : (*sp == ch)) {
            *sp = '\0';
            if (sp-- == str) break;
            i++;
            if (i==num) break;
        }
    }
    return str;
}

/****************************************************************************/
char *                       /* return trimmed string                       */
    scntrims(                /* trim character from both ends of string     */
        char *str,           /* string to trim                              */
        int    ch,           /* character to match                          */
        size_t num)          /* maximum number of characters to trim        */
/****************************************************************************/
{
    return scntrimbegs(scntrimends(str, ch, num), ch, num);
}

/****************************************************************************
Precondition: set dst to null ptr when declaring it, e.g. char *dst=NULL;
         Use: call from scpys macro, e.g. scpys(dst, src);
              scpys macro passes dst by reference
  Obligation: free dst when finished with it, e.g. free(dst);
*****************************************************************************/
char *                  /* return dst                                       */
    _scpys(             /* copy string dynamically                          */
        char **dst,     /* destination string pointer                       */
  const char  *src)     /* source string pointer                            */
/****************************************************************************/
{                       
  size_t dlen;          /* strlen of dst */
  size_t slen;          /* strlen of src */
  int errnum;           /* error number */

  /* if null src pointer */
  if (!src) {
    rseterr(NULL, EINVAL);
    free(*dst);
    *dst = NULL;
    goto done;
  }
  
  if (*dst) {
    dlen = strlen(*dst);
    slen = strlen(src);
    if (dlen < slen) {
      do {
        *dst = (char *) realloc(*dst, slen+1);
        if (!*dst) {
          errnum = rseterr(NULL, ENOMEM);
          if (errnum) goto done;
        }
      } while (!*dst);
    }
    strcpy(*dst, src);
  } else {
     do {
       *dst = strdup(src);
       if (!*dst) {
         errnum = rseterr(NULL, ENOMEM);
         if (errnum) goto done;
       }
     } while (!*dst);
   }
done:
  return *dst;
}

/****************************************************************************
Precondition: set dst to null ptr when declaring it, e.g. char *dst=NULL;
         Use: call from scats macro, e.g. scats(dst, src);
              scats macro passes dst by reference
  Obligation: free dst when finished with it, e.g. free(dst);
*****************************************************************************/
char *                  /* return dst                                       */
    _scats(             /* concat string dynamically                        */
        char **dst,     /* destination string pointer                       */
  const char *src)      /* source string pointer                            */
/****************************************************************************/
{                       
  size_t dlen;          /* strlen of dst */
  size_t slen;          /* strlen of src */

  /* if null src pointer or src empty, do nothing to dst */
  if (!src || !*src) {
    goto done;
  }
  
  if (*dst) {
    dlen = strlen(*dst);
    slen = strlen(src);
    do {
      *dst = (char *) realloc(*dst, dlen+slen+1);
      if (!*dst) {
        if (rseterr(NULL, ENOMEM)) goto done;
      }
    } while (!*dst);
    strcat(*dst, src);
  } else {
     do {
       *dst = strdup(src);
       if (!*dst) {
         if (rseterr(NULL, ENOMEM)) goto done;
       }
     } while (!*dst);
   }
done:
  return *dst;
}
