//XMM.H


#include <iostream.h>
#include <fstream.h>
#include <dos.h>
#include <dir.h>
#include <stdlib.h>


//remove these when not using them, I think:

#include <string.h>

//this fun little typedef defines type BOOLEAN, an enumeration which can be
//passed in or out as a data type.  This is very convenient for functions
//which return TRUE or FALSE to be explicitly cast that way.

#ifndef _BOOL_TYPE_
#define _BOOL_TYPE_

typedef enum{
  TRUE  = 1,
  FALSE = 0
} boolean;

#endif

typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long int dword;

const int XMSINT = 0x2f;

  enum XMSerror{
    FAILURE                        = 0x00,
    OK                             = 0x01,
    //the next parameters are not included in the XMS spec., but returnable
    //as error codes from these functions.
  //parameter:                     value:  returned if:
    XMS_NOT_INITIALIZED            = 0x02, //XMS has not been initialized
    NOT_ENOUGH_XMS                 = 0x03, //there is XMS free, but not enough

    FUNCTION_NOT_IMPLEMENTED       = 0x80,
    VDISK_DETECTED                 = 0x81,
    A20_ERROR                      = 0x82,
    GENERAL_ERROR                  = 0x8E,
    UNRECOVERABLE_ERROR            = 0x8F,
    HMA_DOES_NOT_EXIST             = 0x90,
    HMA_IN_USE                     = 0x91,
    DX_LESS_THAN_HMAMIN            = 0x92,
    HMA_NOT_ALLOCATED              = 0x93,
    A20_STILL_ENABLED              = 0x94,
    NO_MORE_MEMORY                 = 0xA0,
    NO_MORE_HANDLES                = 0xA1,
    INVALID_HANDLE                 = 0xA2,
    SOURCE_HANDLE_INVALID          = 0xA3,
    SOURCE_OFFSET_INVALID          = 0xA4,
    DEST_HANDLE_INVALID            = 0xA5,
    DEST_OFFSET_INVALID            = 0xA6,
    LENGTH_INVALID                 = 0xA7,
    INVALID_OVERLAP                = 0xA8,
    PARITY_ERROR                   = 0xA9,
    BLOCK_NOT_LOCKED               = 0xAA,
    BLOCK_LOCKED                   = 0xAB,
    BLOCK_LOCK_COUNT_OVERFLOW      = 0xAC,
    LOCK_FAILED                    = 0xAD,
    SMALLER_UMB_AVAIL              = 0xB0,
    NO_UMB_AVAIL                   = 0xB1,
    UMB_SEGMENT_NUMBER_INVALID     = 0xB2
  };
  //note that all of the above are only included for completeness, only a few
  //will actually be used or returned.



struct XMS_const{
  enum funct{
    GET_VERSION_NUMBER             = 0x00,
    REQUEST_HMA                    = 0x01,
    RELEASE_HMA                    = 0x02,
    GLOBAL_ENABLE_A20              = 0x03,
    GLOBAL_DISABLE_A20             = 0x04,
    LOCAL_ENABLE_A20               = 0x05,
    LOCAL_DISABLE_A20              = 0x06,
    QUERY_A20                      = 0x07,
    QUERY_FREE_XMS                 = 0x08,
    ALLOCATE_XMS                   = 0x09,
    FREE_XMS                       = 0x0A,
    MOVE_XMS                       = 0x0B,
    LOCK_XMS                       = 0x0C,
    UNLOCK_XMS                     = 0x0D,
    GET_HANDLE_INFO                = 0x0E,
    REALLOCATE_BLOCK               = 0x0F,
    REQUEST_UMB                    = 0x10,
    RELEASE_UMB                    = 0x11,
    REALLOCATE_UMB                 = 0x12,
    //super functions not implemented this version.
    SUPER_QUERY_XMS                = 0x88,
    SUPER_ALLOCATE_XMS             = 0x89,
    SUPER_GET_HANDLE_INFO          = 0x8E,
    SUPER_REALLOCATE_XMS           = 0x8F
  };
};


struct XMSfree{
  long largest;
  long total;
};

//the following structure is an internal one for XMS 3.0

typedef struct{
  dword length;                //must be even
  word src_handl;
  dword src_offset;
  word dest_handl;
  dword dest_offset;
} XMS_move;

static XMS_move EMMstruct;     //this must REMAIN STATIC!!!

struct block{
  word handle;
  unsigned long size_in_bytes;
  unsigned long counter;       //unused...can be used by programmer as index
};


class DashXMM{
  private:
  public:
    DashXMM::DashXMM(boolean verbosity);  //const. for NO SWAPFILE REQUEST
    DashXMM::DashXMM(boolean verbosity, char* s);  //const. for SWAPFILE REQUEST
    ~DashXMM(void);            //destructor 

    fstream swapfile;
    boolean initialized;       //set to TRUE if XMS is initialized
    boolean detected;          //set to TRUE if XMS has been detected
    boolean verbose;           //when set to TRUE, will report errors
    dword bytes_allocated;     //how many bytes of XMS have been allocated
    word XMS_version;
    word driver_version;
    void far(*CONTROL)();  //the control function for the XMS driver
    word XMS_handle;           //handle when using XMS
    void detect(void);
    XMSerror initialize(void);
    void get_versions(void);

    boolean using_swapfile;    //set to TRUE when using a swapfile instead of
			       //XMS
    boolean request_swapfile;  //set to TRUE when swapfile use requested
    XMSerror create_SF(dword Kbytes);
    void delete_SF(void);
    XMSerror SF_move(dword bytes, dword offset_to, dword offset_from);
    XMSerror SF_move(dword bytes, dword offset_to, void far* address_from);
    XMSerror SF_move(dword bytes, void far* address_to, dword offset_from);


  //public:
    unsigned long index;       //unused, can be used by programmer
    int SF_drive;
    XMSerror allocate(dword bytes);
    XMSerror move(dword bytes, dword offset_to, dword offset_from);
    XMSerror move(dword bytes, dword offset_to, void far* address_from);
    XMSerror move(dword bytes, void far* address_to, dword offset_from);
    XMSerror free(void);
    XMSerror query_free_XMS(XMSfree&);
    XMSerror lock(void far*);
    XMSerror unlock();
    void display_error(XMSerror error);

    char swapfile_name[80];
    XMSerror query_free_SF(XMSfree&);
    XMSerror query(XMSfree&);

};
